(* This file is generated by Why3's Coq driver *)
(* Beware! Only edit allowed sections below    *)
Require Import BuiltIn.
Require BuiltIn.
Require int.Int.
Require map.Map.

(* Why3 assumption *)
Inductive datatype  :=
  | Tint : datatype 
  | Tbool : datatype .
Axiom datatype_WhyType : WhyType datatype.
Existing Instance datatype_WhyType.

(* Why3 assumption *)
Inductive operator  :=
  | Oplus : operator 
  | Ominus : operator 
  | Omult : operator 
  | Ole : operator .
Axiom operator_WhyType : WhyType operator.
Existing Instance operator_WhyType.

(* Why3 assumption *)
Definition ident  := Z.

(* Why3 assumption *)
Inductive term  :=
  | Tconst : Z -> term 
  | Tvar : Z -> term 
  | Tderef : Z -> term 
  | Tbin : term -> operator -> term -> term .
Axiom term_WhyType : WhyType term.
Existing Instance term_WhyType.

(* Why3 assumption *)
Inductive fmla  :=
  | Fterm : term -> fmla 
  | Fand : fmla -> fmla -> fmla 
  | Fnot : fmla -> fmla 
  | Fimplies : fmla -> fmla -> fmla 
  | Flet : Z -> term -> fmla -> fmla 
  | Fforall : Z -> datatype -> fmla -> fmla .
Axiom fmla_WhyType : WhyType fmla.
Existing Instance fmla_WhyType.

(* Why3 assumption *)
Inductive value  :=
  | Vint : Z -> value 
  | Vbool : bool -> value .
Axiom value_WhyType : WhyType value.
Existing Instance value_WhyType.

(* Why3 assumption *)
Definition env  := (map.Map.map Z value).

(* Why3 assumption *)
Definition var_env  := (map.Map.map Z value).

(* Why3 assumption *)
Definition ref_env  := (map.Map.map Z value).

(* Why3 assumption *)
Inductive state  :=
  | mk_state : (map.Map.map Z value) -> (map.Map.map Z value) -> state .
Axiom state_WhyType : WhyType state.
Existing Instance state_WhyType.

(* Why3 assumption *)
Definition ref_env1(v:state): (map.Map.map Z value) :=
  match v with
  | (mk_state x x1) => x1
  end.

(* Why3 assumption *)
Definition var_env1(v:state): (map.Map.map Z value) :=
  match v with
  | (mk_state x x1) => x
  end.

Parameter eval_bin: value -> operator -> value -> value.

Axiom eval_bin_def : forall (x:value) (op:operator) (y:value), match (x,
  y) with
  | ((Vint x1), (Vint y1)) =>
      match op with
      | Oplus => ((eval_bin x op y) = (Vint (x1 + y1)%Z))
      | Ominus => ((eval_bin x op y) = (Vint (x1 - y1)%Z))
      | Omult => ((eval_bin x op y) = (Vint (x1 * y1)%Z))
      | Ole => ((x1 <= y1)%Z -> ((eval_bin x op y) = (Vbool true))) /\
          ((~ (x1 <= y1)%Z) -> ((eval_bin x op y) = (Vbool false)))
      end
  | (_, _) => ((eval_bin x op y) = (Vbool false))
  end.

(* Why3 assumption *)
Fixpoint eval_term(s:state) (t:term) {struct t}: value :=
  match t with
  | (Tconst n) => (Vint n)
  | (Tvar id) => (map.Map.get (var_env1 s) id)
  | (Tderef id) => (map.Map.get (ref_env1 s) id)
  | (Tbin t1 op t2) => (eval_bin (eval_term s t1) op (eval_term s t2))
  end.

(* Why3 assumption *)
Fixpoint eval_fmla(s:state) (f:fmla) {struct f}: Prop :=
  match f with
  | (Fterm t) => ((eval_term s t) = (Vbool true))
  | (Fand f1 f2) => (eval_fmla s f1) /\ (eval_fmla s f2)
  | (Fnot f1) => ~ (eval_fmla s f1)
  | (Fimplies f1 f2) => (eval_fmla s f1) -> (eval_fmla s f2)
  | (Flet x t f1) => (eval_fmla (mk_state (map.Map.set (var_env1 s) x
      (eval_term s t)) (ref_env1 s)) f1)
  | (Fforall x Tint f1) => forall (n:Z),
      (eval_fmla (mk_state (map.Map.set (var_env1 s) x (Vint n))
      (ref_env1 s)) f1)
  | (Fforall x Tbool f1) => forall (b:bool),
      (eval_fmla (mk_state (map.Map.set (var_env1 s) x (Vbool b))
      (ref_env1 s)) f1)
  end.

Parameter subst_term: term -> Z -> term -> term.

Axiom subst_term_def : forall (e:term) (x:Z) (t:term),
  match e with
  | (Tconst _) => ((subst_term e x t) = e)
  | (Tvar _) => ((subst_term e x t) = e)
  | (Tderef y) => ((x = y) -> ((subst_term e x t) = t)) /\ ((~ (x = y)) ->
      ((subst_term e x t) = e))
  | (Tbin e1 op e2) => ((subst_term e x t) = (Tbin (subst_term e1 x t) op
      (subst_term e2 x t)))
  end.



(* Why3 goal *)
Theorem eval_subst_term : forall (s:state) (e:term) (x:Z) (t:term),
  ((eval_term s (subst_term e x t)) = (eval_term (mk_state (var_env1 s)
  (map.Map.set (ref_env1 s) x (eval_term s t))) e)).
Proof.
intros s e x t.
induction e.
(* case Tconst *)
rewrite (subst_term_def (Tconst z) x t).
now simpl.
(* case Tvar *)
generalize (subst_term_def (Tvar z) x t).
intro H; rewrite H; clear H.
now simpl.
(* case Tderef *)
generalize (subst_term_def (Tderef z) x t).
intros (H1,H2).
case (Z_eq_dec x z).
(* subcase x=z *)
simpl; intro; subst x.
rewrite Map.Select_eq; auto.
now rewrite H1.
(* subcase x<>z *)
simpl; intro.
rewrite Map.Select_neq; auto.
now rewrite H2.
(* case Tbin *)
rewrite (subst_term_def (Tbin e1 o e2) x t).
simpl.
rewrite IHe2.
now rewrite IHe1.
Qed.


