-- $Id: unit.ads 11375 2008-10-08 10:40:42Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


with EStrings;
with StringList;

--# inherit CommandLineData,
--#         CommonStringUtilities,
--#         Dictionary,
--#         ErrorHandler,
--#         EStrings,
--#         LexTokenManager,
--#         SparkLex,
--#         SparkMakeDebug,
--#         SparkMakeErrors,
--#         SPARK_IO,
--#         SPSymbols,
--#         StringList,
--#         StringUtilities,
--#         TokenManager;

package Unit
is

   type Kind is (PackageSpecificationUnit,
                 PublicChildPackageSpecificationUnit,
                 PrivateChildPackageSpecificationUnit,
                 MainProgramUnit,
                 PackageBodyUnit,
                 SeparateBodyUnit);

   subtype SpecificationUnit is Kind range
     PackageSpecificationUnit .. PrivateChildPackageSpecificationUnit;

   subtype ChildSpecificationUnit is Kind range
     PublicChildPackageSpecificationUnit .. PrivateChildPackageSpecificationUnit;


   type Id is
      record
         TheName : EStrings.T;
         TheKind : Kind;
      end record;

   NullId : constant Id := Id'(TheName => EStrings.EmptyString,
                               TheKind => Kind'First);

   type Object is
      record
         TheId             : Id;
         TheFile           : EStrings.T;
         TheWithedUnits    : StringList.Object;
         TheInheritedUnits : StringList.Object;
      end record;

   NullObject : constant Object :=
     Object'(TheId             => NullId,
             TheFile           => EStrings.EmptyString,
             TheWithedUnits    => StringList.NullObject,
             TheInheritedUnits => StringList.NullObject);

   -----------------------------------------------------------------------------

   function KindToString (TheUnit : Kind) return EStrings.T;

   -----------------------------------------------------------------------------

   function AreEqual (L, R : Id) return Boolean;

   -----------------------------------------------------------------------------

   function LessThan (L, R : Id) return Boolean;

   -----------------------------------------------------------------------------

   function Prefix (EStr : EStrings.T) return
     EStrings.T;

   -----------------------------------------------------------------------------

   function ConstructSpecUnitId
     (TheName   : EStrings.T;
      IsPrivate : Boolean) return Id;

   -----------------------------------------------------------------------------

   procedure GetUnit (InFile  : in     EStrings.T;
                      TheUnit :    out Object);
   --# global in     CommandLineData.Content;
   --#        in     Dictionary.Dict;
   --#        in out ErrorHandler.ErrorContext;
   --#        in out LexTokenManager.StringTable;
   --#        in out SPARK_IO.File_Sys;
   --#           out SparkLex.CurrLine;
   --# derives ErrorHandler.ErrorContext,
   --#         LexTokenManager.StringTable,
   --#         SparkLex.CurrLine,
   --#         SPARK_IO.File_Sys,
   --#         TheUnit                     from CommandLineData.Content,
   --#                                          Dictionary.Dict,
   --#                                          ErrorHandler.ErrorContext,
   --#                                          InFile,
   --#                                          LexTokenManager.StringTable,
   --#                                          SPARK_IO.File_Sys;
   --
   -- Extracts the Unit information from the given file.

   -----------------------------------------------------------------------------

   procedure OutputObject (TheUnit : in Object);
   --# global in out SPARK_IO.File_Sys;
   --# derives SPARK_IO.File_Sys from *,
   --#                                TheUnit;
   --
   -- For debug only

   procedure OutputId (TheUnit : in Id);
   --# global in out SPARK_IO.File_Sys;
   --# derives SPARK_IO.File_Sys from *,
   --#                                TheUnit;
   --
   -- For debug only

end Unit;
