-- $Id: sparkmakeerrors.ads 11882 2008-12-12 10:45:23Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


with EStrings;

--# inherit EStrings,
--#         SparkMakeDebug,
--#         SPARK_IO,
--#         SystemErrors,
--#         Version;

package SparkMakeErrors
is

   type Fault is (DuplicateErrors,
                  InvalidSwitch,
                  DuplicateSwitch,
                  InvalidArgument,
                  CannotFindFile,
                  CannotOpenFile,
                  CannotCloseFile,
                  -- Items above this line are errors, items below are warnings.
                  -- See subtypes in package body.
                  MultipleMainPrograms,
                  DuplicateOkay,
                  InvalidUnit);


   procedure Report (TheFault : in Fault;
                     EStr1    : in EStrings.T;
                     EStr2    : in EStrings.T;
                     EStr3    : in EStrings.T);
   --# global in out SPARK_IO.FILE_SYS;
   --# derives SPARK_IO.FILE_SYS from *,
   --#                                EStr1,
   --#                                EStr2,
   --#                                EStr3,
   --#                                TheFault;

   procedure Fatal (Text : in String);
   --# global in out SPARK_IO.FILE_SYS;
   --# derives SPARK_IO.FILE_SYS from *,
   --#                                Text;

end SparkMakeErrors;
