-- $Id: sparkmakeerrors.adb 12298 2009-01-26 12:48:06Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


with SPARK_IO;
with SparkMakeDebug;
with SystemErrors;

package body SparkMakeErrors
is


   subtype Error is Fault range Fault'First .. CannotCloseFile;
   subtype Warning is Fault range Fault'Succ (Error'Last) .. Fault'Last;


   procedure Report (TheFault : in Fault;
                     EStr1    : in EStrings.T;
                     EStr2    : in EStrings.T;
                     EStr3    : in EStrings.T)
   is
   begin
      case TheFault is

         when Error =>
            SPARK_IO.Put_String (SPARK_IO.Standard_Output,
                                 "!!! Sparkmake error: ",
                                 0);

         when Warning =>
            SPARK_IO.Put_String (SPARK_IO.Standard_Output,
                                 ">>> Sparkmake warning: ",
                                 0);
      end case;

      case TheFault is

         -- COMMAND LINE FAULTS

         when InvalidSwitch =>
            EStrings.PutString (SPARK_IO.Standard_Output,
                                       EStr1);
            SPARK_IO.Put_Line (SPARK_IO.Standard_Output,
                               " is not a recognised switch",
                               0);

         when InvalidArgument =>
            EStrings.PutString (SPARK_IO.Standard_Output,
                                       EStr1);
            SPARK_IO.Put_String (SPARK_IO.Standard_Output,
                                 " is not a valid argument for switch ",
                                 0);
            EStrings.PutLine (SPARK_IO.Standard_Output,
                                     EStr2);

         when DuplicateSwitch =>
            SPARK_IO.Put_String (SPARK_IO.Standard_Output,
                                 "The switch ",
                                 0);
            EStrings.PutString (SPARK_IO.Standard_Output,
                                       EStr1);
            SPARK_IO.Put_Line (SPARK_IO.Standard_Output,
                               " cannot be duplicated",
                               0);

         when CannotFindFile =>
            SPARK_IO.Put_String (SPARK_IO.Standard_Output,
                                 "Could not find the file ",
                                 0);
            EStrings.PutLine (SPARK_IO.Standard_Output,
                                     EStr1);

            -- INDEX FILE FAULTS

         when DuplicateErrors =>
            SPARK_IO.Put_String (SPARK_IO.Standard_Output,
                                 "Unit ",
                                 0);
            EStrings.PutString (SPARK_IO.Standard_Output,
                                       EStr1);
            SPARK_IO.Put_String (SPARK_IO.Standard_Output,
                                 " is duplicated in files ",
                                 0);
            EStrings.PutString (SPARK_IO.Standard_Output,
                                       EStr2);
            SPARK_IO.Put_String (SPARK_IO.Standard_Output,
                                 " and ",
                                 0);
            EStrings.PutLine (SPARK_IO.Standard_Output,
                                     EStr3);

         when DuplicateOkay =>
            SPARK_IO.Put_String (SPARK_IO.Standard_Output,
                                 "Unit ",
                                 0);
            EStrings.PutString (SPARK_IO.Standard_Output,
                                       EStr1);
            SPARK_IO.Put_String (SPARK_IO.Standard_Output,
                                 " in file ",
                                 0);
            EStrings.PutString (SPARK_IO.Standard_Output,
                                       EStr2);
            SPARK_IO.Put_String (SPARK_IO.Standard_Output,
                                 " is already seen in ",
                                 0);
            EStrings.PutLine (SPARK_IO.Standard_Output,
                                     EStr3);

         when InvalidUnit =>
            SPARK_IO.Put_String (SPARK_IO.Standard_Output,
                                 "File ",
                                 0);
            EStrings.PutString (SPARK_IO.Standard_Output,
                                       EStr1);
            SPARK_IO.Put_Line (SPARK_IO.Standard_Output,
                               " does not contain a valid unit",
                               0);

         when MultipleMainPrograms =>
            SPARK_IO.Put_String (SPARK_IO.Standard_Output,
                                 "Files ",
                                 0);
            EStrings.PutString (SPARK_IO.Standard_Output,
                                       EStr1);
            SPARK_IO.Put_String (SPARK_IO.Standard_Output,
                                 " and ",
                                 0);
            EStrings.PutString (SPARK_IO.Standard_Output,
                                       EStr2);
            SPARK_IO.Put_Line (SPARK_IO.Standard_Output,
                               " both contain main programs",
                               0);

            -- GENERAL FILE HANDLING FAULTS
         when CannotOpenFile =>
            SPARK_IO.Put_String (SPARK_IO.Standard_Output,
                                 "Cannot open ",
                                 0);
            EStrings.PutLine (SPARK_IO.Standard_Output,
                                     EStr1);

         when CannotCloseFile =>
            SPARK_IO.Put_String (SPARK_IO.Standard_Output,
                                 "Cannot close ",
                                 0);
            EStrings.PutLine (SPARK_IO.Standard_Output,
                                     EStr1);
      end case;
   end Report;


   procedure Fatal (Text : in String)
   is
      --# hide Fatal;
   begin
      SparkMakeDebug.ReportText ("Fatal error: " & Text);
      SystemErrors.FatalError
        (SysErr => SystemErrors.OtherInternalError,
         Msg => "Internal error. ");
   end Fatal;

end SparkMakeErrors;
