-- $Id: sparkmakedebug.adb 11375 2008-10-08 10:40:42Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


with SPARK_IO;
with SparkMakeCommandLine;

package body SparkMakeDebug
is
   ---------------------------------------------------------------------------
   -- This package body is NOT SPARK
   ---------------------------------------------------------------------------

   procedure StartDebugLine
   is
   begin
      SPARK_IO.Put_String (File => SPARK_IO.Standard_Output,
                           Item => ">>> Debug: ",
                           Stop => 0);
   end StartDebugLine;

   -----------------------------------------------------------------------------------

   procedure ReportText (Text  : in String)
   is
   begin
      if SparkMakeCommandLine.DebugOn then
         StartDebugLine;

         SPARK_IO.Put_Line (File => SPARK_IO.Standard_Output,
                            Item => Text,
                            Stop => 0);
      end if;
   end ReportText;

   -----------------------------------------------------------------------------------

   procedure ReportTextEText (Text  : in String;
                              EText : in EStrings.T)
   is
   begin
      if SparkMakeCommandLine.DebugOn then
         StartDebugLine;

         SPARK_IO.Put_String (File => SPARK_IO.Standard_Output,
                              Item => Text,
                              Stop => 0);

         EStrings.PutLine (File => SPARK_IO.Standard_Output,
                                  EStr => EText);
      end if;
   end ReportTextEText;

   -----------------------------------------------------------------------------------

   procedure ReportList (Text : in String;
                         List : in StringList.Object)
   is
   begin
      if SparkMakeCommandLine.DebugOn then
         StartDebugLine;

         SPARK_IO.Put_String (File => SPARK_IO.Standard_Output,
                              Item => Text,
                              Stop => 0);

         StringList.Output (TheList => List,
                            How => StringList.Horizontal);
      end if;
   end ReportList;

   -----------------------------------------------------------------------------------

   procedure ReportCondText (Cond      : in Boolean;
                             TrueText  : in String;
                             FalseText : in String)
   is
   begin
      if SparkMakeCommandLine.DebugOn then
         StartDebugLine;
         if Cond then
            SPARK_IO.Put_Line (File => SPARK_IO.Standard_Output,
                               Item => TrueText,
                               Stop => 0);
         else
            SPARK_IO.Put_Line (File => SPARK_IO.Standard_Output,
                               Item => FalseText,
                               Stop => 0);
         end if;
      end if;
   end ReportCondText;


end SparkMakeDebug;
