-- $Id: sparkmakecommandline.ads 13045 2009-04-20 08:41:19Z Rod Chapman $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


with EStrings;
with StringList;

--# inherit CommandLine,
--#         CommandLineData,
--#         EStrings,
--#         FileSystem,
--#         Directory_Operations,
--#         RegularExpression,
--#         SparkMakeDebug,
--#         SparkMakeErrors,
--#         SPARK_IO,
--#         StringList,
--#         SystemErrors,
--#         Version;

package SparkMakeCommandLine
--# own State;
is

   -- Switches:
   --   /meta=filename           filename is the name of the output meta file
   --                            Default: rootfilename.smf
   --
   --   /nometafile              Do not produce a meta file
   --                            Default: False
   --
   --   /index=filename          filename is the name of the index file output
   --                            Default: rootfilename.idx
   --
   --   /noindexfile             Do not produce an index file
   --                            Default: False
   --
   --   /path=Full | Relative    Full or Relative path names in output files
   --                            Default: Full
   --
   --   /debug                   outputs additional debug info as the make progresses
   --                            Default: Full
   --
   --   /duplicates_are_errors   Fails if duplicate files are found
   --                            Default : False
   --
   --   /directory=dirname       Tells make to look in and under these directories
   --                            Current directory is always searched and is the default.
   --
   --   /include=regexp          include these files
   --                            Default: *.ad[bs]
   --
   --   /exclude=regexp          exclude these files
   --                            Default: exclude no files
   --
   --   /annotation_character=char
   --                            Recognise this character as annotation character
   --                            Default: #
   --
   --   /help                    prints off help information
   --
   --   /version                 prints off version information
   --
   -- Arguments
   --   rootfilename             Filename is the root of the make. If not specified
   --                            then index and meta files for analysis of all files
   --                            in the directory (and subdirectories) will be generated
   --                            named spark.idx and spark.smf.
   --

   ----------------------------------------------------------------------
   -- Constructor
   ----------------------------------------------------------------------

   procedure Process (Success        : out Boolean;
                      HelpOrVerFound : out Boolean);
   --# global in     CommandLine.State;
   --#        in out CommandLineData.Content;
   --#        in out SPARK_IO.FILE_SYS;
   --#           out State;
   --# derives CommandLineData.Content,
   --#         SPARK_IO.FILE_SYS       from *,
   --#                                      CommandLine.State &
   --#         HelpOrVerFound,
   --#         State,
   --#         Success                 from CommandLine.State;


   ----------------------------------------------------------------------
   -- Accessors
   ----------------------------------------------------------------------

   type PathType is (Undefined, Full, Relative);

   function PathRequired return PathType;
   --# global in State;

   function MetaFileName return EStrings.T;
   --# global in State;

   function IndexFileName return EStrings.T;
   --# global in State;

   function RootFileName return EStrings.T;
   --# global in State;

   function DuplicatesError return Boolean;
   --# global in State;

   function TheDirectoryNames return StringList.Object;
   --# global in State;

   function TheIncFileRegExps return StringList.Object;
   --# global in State;

   function TheExcFileRegExps return StringList.Object;
   --# global in State;

   function DebugOn return Boolean;
   --# global in State;

   function NoMetaFile return Boolean;
   --# global in State;

   function NoIndexFile return Boolean;
   --# global in State;

end SparkMakeCommandLine;
