-- $Id: regularexpression.ads 11375 2008-10-08 10:40:42Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


with EStrings;
--# inherit EStrings;

package RegularExpression
is

   type Object is private;

   function Create (EStr : EStrings.T) return Object;
   --
   -- Creates a regular expression from EStr.
   -- If EStr does not represent a valid regular expression a null object is returned.


   ------------------------------------------------------
   -- Accessors
   ------------------------------------------------------

   function IsNull (O : Object) return Boolean;

   function Matches (EStr      : EStrings.T;
                     TheRegExp : Object) return Boolean;
   --
   -- Returns True is EStr matches TheRegularExp

private

   type Object is
      record
         TheRegExp : EStrings.T;
         IsNullExp : Boolean;
      end record;

   NullObject : constant Object :=
     Object'(TheRegExp => EStrings.EmptyString,
             IsNullExp => True);

end RegularExpression;
