-- $Id: symbols_dump.ads 11998 2009-01-02 14:42:09Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================

with Sparklalr_IO;
with Sparklalr_Common;
with Sparklalr_Error;
--# inherit Command_Line_Options,
--#         Sparklalr_Common,
--#         Sparklalr_Error,
--#         Sparklalr_IO,
--#         Sparklalr_Level;

package Symbols_Dump
   --# own State;
is

   procedure Initialise;
   --# global out State;
   --# derives State from ;

   procedure Define
     (Tnt           : in Boolean;
      F             : in Sparklalr_IO.File_Type;
      Gram_Rules    : in Boolean;
      Token         : in Sparklalr_Common.Id_Name;
      Col           : in Sparklalr_Error.Err_Col_T;
      Result_Define : out Integer);
   --# global in out Sparklalr_Error.State;
   --#        in out Sparklalr_IO.Outputs;
   --#        in out Sparklalr_Level.State;
   --#        in out State;
   --# derives Result_Define         from State,
   --#                                    Tnt &
   --#         Sparklalr_Error.State from *,
   --#                                    Col,
   --#                                    State,
   --#                                    Tnt &
   --#         Sparklalr_IO.Outputs  from *,
   --#                                    F,
   --#                                    State,
   --#                                    Tnt &
   --#         Sparklalr_Level.State from *,
   --#                                    Gram_Rules,
   --#                                    State,
   --#                                    Tnt &
   --#         State                 from *,
   --#                                    Tnt,
   --#                                    Token;

   procedure Print_Sym
     (F    : in Sparklalr_IO.File_Type;
      Sym  : in Sparklalr_Common.Sym_Range;
      Posn : in out Integer;
      Tab  : in Integer;
      Comm : in Boolean);
   --# global in     State;
   --#        in out Sparklalr_IO.Outputs;
   --# derives Posn                 from *,
   --#                                   State,
   --#                                   Sym,
   --#                                   Tab &
   --#         Sparklalr_IO.Outputs from *,
   --#                                   Comm,
   --#                                   F,
   --#                                   Posn,
   --#                                   State,
   --#                                   Sym,
   --#                                   Tab;

   procedure Print_String_Sym
     (F          : in Sparklalr_IO.File_Type;
      String_Var : in Sparklalr_Common.Id_Name;
      Sym        : in Sparklalr_Common.Sym_Range;
      Posn       : in out Integer;
      Tab        : in Integer;
      Comm       : in Boolean);
   --# global in     State;
   --#        in out Sparklalr_IO.Outputs;
   --# derives Posn                 from *,
   --#                                   State,
   --#                                   String_Var,
   --#                                   Sym,
   --#                                   Tab &
   --#         Sparklalr_IO.Outputs from *,
   --#                                   Comm,
   --#                                   F,
   --#                                   Posn,
   --#                                   State,
   --#                                   String_Var,
   --#                                   Sym,
   --#                                   Tab;

   procedure Symbol_Strings_Out;
   --# global in     Command_Line_Options.State;
   --#        in     State;
   --#        in out Sparklalr_IO.Outputs;
   --#        in out Sparklalr_IO.State;
   --# derives Sparklalr_IO.Outputs from *,
   --#                                   Command_Line_Options.State,
   --#                                   Sparklalr_IO.State,
   --#                                   State &
   --#         Sparklalr_IO.State   from *,
   --#                                   Command_Line_Options.State;

   procedure Find
     (Tnt         : in Boolean;
      F           : in Sparklalr_IO.File_Type;
      Gram_Rules  : in Boolean;
      Token       : in Sparklalr_Common.Id_Name;
      Col         : in Sparklalr_Error.Err_Col_T;
      Result_Find : out Integer);
   --# global in out Sparklalr_Error.State;
   --#        in out Sparklalr_IO.Outputs;
   --#        in out Sparklalr_Level.State;
   --#        in out State;
   --# derives Result_Find,
   --#         State                 from State,
   --#                                    Tnt,
   --#                                    Token &
   --#         Sparklalr_Error.State from *,
   --#                                    Col,
   --#                                    State,
   --#                                    Tnt,
   --#                                    Token &
   --#         Sparklalr_IO.Outputs  from *,
   --#                                    F,
   --#                                    State,
   --#                                    Tnt,
   --#                                    Token &
   --#         Sparklalr_Level.State from *,
   --#                                    Gram_Rules,
   --#                                    State,
   --#                                    Tnt,
   --#                                    Token;

   procedure Symbols_Package_Out (F : in Sparklalr_IO.File_Type);
   --# global in     State;
   --#        in out Sparklalr_IO.Outputs;
   --# derives Sparklalr_IO.Outputs from *,
   --#                                   F,
   --#                                   State;

   -- Getter
   function Get_Nterms return Integer;
   --# global in State;

   function Get_Nnon_Terms return Integer;
   --# global in State;

   function Get_Term_Set (I : in Sparklalr_Common.Term_Range) return Sparklalr_Common.Id_Name;
   --# global in State;

   function Get_Nterm_Set (I : in Sparklalr_Common.Non_Term_Range) return Sparklalr_Common.Id_Name;
   --# global in State;

end Symbols_Dump;
