-- $Id: symbols_dump.adb 11998 2009-01-02 14:42:09Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================

with Command_Line_Options;
with Sparklalr_Level;

package body Symbols_Dump
   --# own State is
   --#   Nterm_Set,
   --#   Term_Set,
   --#   Nterms,
   --#   Nnon_Terms;
is

   type Nterm_Set_T is array (Sparklalr_Common.Non_Term_Range) of Sparklalr_Common.Id_Name;
   type Term_Set_T is array (Sparklalr_Common.Term_Range) of Sparklalr_Common.Id_Name;

   Nterm_Set : Nterm_Set_T;
   Term_Set  : Term_Set_T;

   Nterms, Nnon_Terms : Integer;

   procedure Initialise
      --# global out Nnon_Terms;
      --#        out Nterms;
      --#        out Nterm_Set;
      --#        out Term_Set;
      --# derives Nnon_Terms,
      --#         Nterms,
      --#         Nterm_Set,
      --#         Term_Set   from ;
   is
   begin
      Nterms     := -1;
      Nnon_Terms := 0;
      Nterm_Set  := Nterm_Set_T'(others => Sparklalr_Common.Id_Name'(others => ' '));
      Term_Set   := Term_Set_T'(others => Sparklalr_Common.Id_Name'(others => ' '));
   end Initialise;

   procedure Define
     (Tnt           : in Boolean;
      F             : in Sparklalr_IO.File_Type;
      Gram_Rules    : in Boolean;
      Token         : in Sparklalr_Common.Id_Name;
      Col           : in Sparklalr_Error.Err_Col_T;
      Result_Define : out Integer)
      -- DEFINES A NEW (NON) TERMINAL
      --# global in out Nnon_Terms;
      --#        in out Nterms;
      --#        in out Nterm_Set;
      --#        in out Sparklalr_Error.State;
      --#        in out Sparklalr_IO.Outputs;
      --#        in out Sparklalr_Level.State;
      --#        in out Term_Set;
      --# derives Nnon_Terms,
      --#         Nterms                from *,
      --#                                    Tnt &
      --#         Nterm_Set             from *,
      --#                                    Nnon_Terms,
      --#                                    Tnt,
      --#                                    Token &
      --#         Result_Define         from Nnon_Terms,
      --#                                    Nterms,
      --#                                    Tnt &
      --#         Sparklalr_Error.State from *,
      --#                                    Col,
      --#                                    Nnon_Terms,
      --#                                    Nterms,
      --#                                    Tnt &
      --#         Sparklalr_IO.Outputs  from *,
      --#                                    F,
      --#                                    Nnon_Terms,
      --#                                    Tnt &
      --#         Sparklalr_Level.State from *,
      --#                                    Gram_Rules,
      --#                                    Nterms,
      --#                                    Tnt &
      --#         Term_Set              from *,
      --#                                    Nterms,
      --#                                    Tnt,
      --#                                    Token;
   is
   begin
      Result_Define := 0;
      if Tnt then
         if Nnon_Terms >= Sparklalr_Common.Non_Term_Lim then
            Sparklalr_Error.Syn_Error (15, Col);
            Sparklalr_IO.Put_Int (F, Nnon_Terms, 6);
            Sparklalr_IO.Put (F, " NONTERMINALS (");
            Sparklalr_IO.Put_Int (F, Sparklalr_Common.Non_Term_Lim, 1);
            Sparklalr_IO.Put_Line (F, " MAX)");
         else
            Nnon_Terms             := Nnon_Terms + 1;
            Nterm_Set (Nnon_Terms) := Token;
            Result_Define          := Sparklalr_Common.Nt_Base + Nnon_Terms;
         end if;
      else
         if Nterms >= Sparklalr_Common.Term_Lim then
            Sparklalr_Error.Syn_Error (16, Col);
         else
            Nterms            := Nterms + 1;
            Term_Set (Nterms) := Token;
            if Gram_Rules then
               Sparklalr_Level.Initiate_Term_Lev (Nterms);
            end if;
            Result_Define := Nterms;
         end if;
      end if;
   end Define;

   procedure Print_Sym
     (F    : in Sparklalr_IO.File_Type;
      Sym  : in Sparklalr_Common.Sym_Range;
      Posn : in out Integer;
      Tab  : in Integer;
      Comm : in Boolean)
      --# global in     Nterm_Set;
      --#        in     Term_Set;
      --#        in out Sparklalr_IO.Outputs;
      --# derives Posn                 from *,
      --#                                   Nterm_Set,
      --#                                   Sym,
      --#                                   Tab,
      --#                                   Term_Set &
      --#         Sparklalr_IO.Outputs from *,
      --#                                   Comm,
      --#                                   F,
      --#                                   Nterm_Set,
      --#                                   Posn,
      --#                                   Sym,
      --#                                   Tab,
      --#                                   Term_Set;
   is
      Id : Sparklalr_Common.Id_Name;
      I  : Sparklalr_Common.Id_Length_Count;
      J  : Integer;
   begin
      if Sym > Sparklalr_Common.Nt_Base then
         Id := Nterm_Set (Sym - Sparklalr_Common.Nt_Base);
      else
         Id := Term_Set (Sym);
      end if;
      I := Sparklalr_Common.Id_Length;
      while Id (I) = ' ' loop
         I := I - 1;
      end loop;
      if (Posn + I) > (Sparklalr_Common.Page_Width - 2) then
         Sparklalr_IO.New_Line (F);
         if Comm then
            Sparklalr_IO.Put (F, "--");
            Sparklalr_Common.Put_N_Chars (F, ' ', Tab - 2);
         else
            Sparklalr_Common.Put_N_Chars (F, ' ', Tab);
         end if;
         Posn := I + Tab;
      else
         Posn := Posn + I;
      end if;
      Sparklalr_IO.Put_Char (F, ' ');
      J := 1;
      while J <= I loop
         Sparklalr_IO.Put_Char (F, Id (J));
         J := J + 1;
      end loop;
   end Print_Sym;

   procedure Print_String_Sym
     (F          : in Sparklalr_IO.File_Type;
      String_Var : in Sparklalr_Common.Id_Name;
      Sym        : in Sparklalr_Common.Sym_Range;
      Posn       : in out Integer;
      Tab        : in Integer;
      Comm       : in Boolean)
      --# global in     Nterm_Set;
      --#        in     Term_Set;
      --#        in out Sparklalr_IO.Outputs;
      --# derives Posn                 from *,
      --#                                   Nterm_Set,
      --#                                   String_Var,
      --#                                   Sym,
      --#                                   Tab,
      --#                                   Term_Set &
      --#         Sparklalr_IO.Outputs from *,
      --#                                   Comm,
      --#                                   F,
      --#                                   Nterm_Set,
      --#                                   Posn,
      --#                                   String_Var,
      --#                                   Sym,
      --#                                   Tab,
      --#                                   Term_Set;
   is
      Id   : Sparklalr_Common.Id_Name;
      I, J : Sparklalr_Common.Id_Length_Count;
      K    : Integer;
   begin
      I := Sparklalr_Common.Id_Length;
      while String_Var (I) = ' ' loop
         I := I - 1;
      end loop;
      if Sym > Sparklalr_Common.Nt_Base then
         Id := Nterm_Set (Sym - Sparklalr_Common.Nt_Base);
      else
         Id := Term_Set (Sym);
      end if;
      J := Sparklalr_Common.Id_Length;
      while Id (J) = ' ' loop
         J := J - 1;
      end loop;
      if ((Posn + I) + J) > (Sparklalr_Common.Page_Width - 2) then
         Sparklalr_IO.New_Line (F);
         if Comm then
            Sparklalr_IO.Put (F, "--");
            Sparklalr_Common.Put_N_Chars (F, ' ', Tab - 2);
         else
            Sparklalr_Common.Put_N_Chars (F, ' ', Tab);
         end if;
         Posn := (I + J) + Tab;
      else
         Posn := (Posn + I) + J;
      end if;
      Sparklalr_IO.Put_Char (F, ' ');
      K := 1;
      while K <= I loop
         Sparklalr_IO.Put_Char (F, String_Var (K));
         K := K + 1;
      end loop;
      K := 1;
      while K <= J loop
         Sparklalr_IO.Put_Char (F, Id (K));
         K := K + 1;
      end loop;
   end Print_String_Sym;

   procedure Symbol_Strings_Out
      --# global in     Command_Line_Options.State;
      --#        in     Nnon_Terms;
      --#        in     Nterms;
      --#        in     Nterm_Set;
      --#        in     Term_Set;
      --#        in out Sparklalr_IO.Outputs;
      --#        in out Sparklalr_IO.State;
      --# derives Sparklalr_IO.Outputs from *,
      --#                                   Command_Line_Options.State,
      --#                                   Nnon_Terms,
      --#                                   Nterms,
      --#                                   Nterm_Set,
      --#                                   Sparklalr_IO.State,
      --#                                   Term_Set &
      --#         Sparklalr_IO.State   from *,
      --#                                   Command_Line_Options.State;
   is
      Sp_Symbols   : Sparklalr_IO.File_Type;
      Posn         : Integer;
      File_Name    : Sparklalr_IO.File_Name;
      File_Success : Boolean;
      Sym          : Integer;
   begin
      File_Name := Command_Line_Options.Get_File_Name;
      Sparklalr_IO.Rewrite (Sp_Symbols, File_Name, ".SYM", File_Success);
      if not File_Success then
         Sparklalr_IO.Exit_St ("Unable to open output SYM file", Sparklalr_IO.Error);
      end if;
      Sparklalr_IO.Put_Line (Sp_Symbols, "&TERMINALS");
      Sym := 0;
      while Sym <= Nterms loop
         Posn := 1;
         --# accept F, 10, Posn, "Ineffective assignment here expected and OK";
         Print_Sym (Sp_Symbols, Sym, Posn, 1, False);
         --# end accept;
         Sparklalr_IO.New_Line (Sp_Symbols);
         Sym := Sym + 1;
      end loop;
      Sparklalr_IO.Put_Line (Sp_Symbols, "&NONTERMINALS");
      Sym := Sparklalr_Common.Nt_Base + 1;
      while Sym <= Sparklalr_Common.Nt_Base + Nnon_Terms loop
         Posn := 1;
         --# accept F, 10, Posn, "Ineffective assignment here expected and OK";
         Print_Sym (Sp_Symbols, Sym, Posn, 5, False);
         --# end accept;
         Sparklalr_IO.New_Line (Sp_Symbols);
         Sym := Sym + 1;
      end loop;
      Sparklalr_IO.Put_Line (Sp_Symbols, "&END");
   end Symbol_Strings_Out;

   procedure Find
     (Tnt         : in Boolean;
      F           : in Sparklalr_IO.File_Type;
      Gram_Rules  : in Boolean;
      Token       : in Sparklalr_Common.Id_Name;
      Col         : in Sparklalr_Error.Err_Col_T;
      Result_Find : out Integer)
      -- FINDS A (NON) TERMINAL
      --# global in out Nnon_Terms;
      --#        in out Nterms;
      --#        in out Nterm_Set;
      --#        in out Sparklalr_Error.State;
      --#        in out Sparklalr_IO.Outputs;
      --#        in out Sparklalr_Level.State;
      --#        in out Term_Set;
      --# derives Nnon_Terms,
      --#         Nterms,
      --#         Nterm_Set,
      --#         Result_Find,
      --#         Term_Set              from Nnon_Terms,
      --#                                    Nterms,
      --#                                    Nterm_Set,
      --#                                    Term_Set,
      --#                                    Tnt,
      --#                                    Token &
      --#         Sparklalr_Error.State from *,
      --#                                    Col,
      --#                                    Nnon_Terms,
      --#                                    Nterms,
      --#                                    Nterm_Set,
      --#                                    Term_Set,
      --#                                    Tnt,
      --#                                    Token &
      --#         Sparklalr_IO.Outputs  from *,
      --#                                    F,
      --#                                    Nnon_Terms,
      --#                                    Nterms,
      --#                                    Nterm_Set,
      --#                                    Term_Set,
      --#                                    Tnt,
      --#                                    Token &
      --#         Sparklalr_Level.State from *,
      --#                                    Gram_Rules,
      --#                                    Nnon_Terms,
      --#                                    Nterms,
      --#                                    Nterm_Set,
      --#                                    Term_Set,
      --#                                    Tnt,
      --#                                    Token;
   is
      I     : Integer;
      Found : Boolean;
   begin
      Result_Find := 0;
      Found       := False;
      I           := 1;
      while (I <= Nterms) and not Found loop
         if Term_Set (I) = Token then
            Result_Find := I;
            Found       := True;
         else
            I := I + 1;
         end if;
      end loop;
      if not Found then
         I     := 1;
         Found := False;
         while (I <= Nnon_Terms) and not Found loop
            if Nterm_Set (I) = Token then
               Found       := True;
               Result_Find := I + Sparklalr_Common.Nt_Base;
            else
               I := I + 1;
            end if;
         end loop;
         if not Found then
            Define (Tnt, F, Gram_Rules, Token, Col, Result_Find);
         end if;
      end if;
   end Find;

   -- -------- The following procedures print out the SPARK parser tables ----
   procedure Symbols_Package_Out (F : in Sparklalr_IO.File_Type)
      --# global in     Nnon_Terms;
      --#        in     Nterms;
      --#        in     Nterm_Set;
      --#        in     Term_Set;
      --#        in out Sparklalr_IO.Outputs;
      --# derives Sparklalr_IO.Outputs from *,
      --#                                   F,
      --#                                   Nnon_Terms,
      --#                                   Nterms,
      --#                                   Nterm_Set,
      --#                                   Term_Set;
   is
      Posn : Integer;
      I    : Integer;
   begin
      Sparklalr_IO.Put_Line (F, "package SPSymbols is");
      Sparklalr_IO.New_Line (F);
      Sparklalr_IO.Put_Line (F, "   type SPSymbol is (");
      Posn := 21;
      Sparklalr_Common.Put_N_Chars (F, ' ', 21);
      I := 0;
      while I <= Nterms loop
         Print_Sym (F, I, Posn, 21, False);
         Sparklalr_IO.Put_Char (F, ',');
         Posn := Posn + 2;
         I    := I + 1;
      end loop;
      Sparklalr_IO.New_Line (F);
      Sparklalr_IO.New_Line (F);
      Sparklalr_Common.Put_N_Chars (F, ' ', 21);
      Posn := 21;
      I    := Sparklalr_Common.Nt_Base + 1;
      while I <= (Sparklalr_Common.Nt_Base + Nnon_Terms) - 1 loop
         Print_Sym (F, I, Posn, 21, False);
         Sparklalr_IO.Put_Char (F, ',');
         Posn := Posn + 2;
         I    := I + 1;
      end loop;
      --# accept F, 10, Posn, "Ineffective assignment here expected and OK";
      Print_Sym (F, Sparklalr_Common.Nt_Base + Nnon_Terms, Posn, 21, False);
      --# end accept;
      Sparklalr_IO.New_Line (F);
      Sparklalr_IO.Put_Line (F, "                   );");
      Sparklalr_IO.Put (F, "   subtype SPTerminal is SPSymbol range ");
      Posn := 40;
      Print_Sym (F, 0, Posn, 10, False);
      Sparklalr_IO.Put (F, " .. ");
      Posn := Posn + 2;
      --# accept F, 10, Posn, "Ineffective assignment here expected and OK";
      Print_Sym (F, Nterms, Posn, 10, False);
      --# end accept;
      Sparklalr_IO.Put_Line (F, ";");
      Sparklalr_IO.Put (F, "   subtype SPNonTerminal is SPSymbol range ");
      Posn := 42;
      Print_Sym (F, Sparklalr_Common.Nt_Base + 1, Posn, 10, False);
      Sparklalr_IO.Put (F, " .. ");
      Posn := Posn + 2;
      --# accept F, 10, Posn, "Ineffective assignment here expected and OK";
      Print_Sym (F, Sparklalr_Common.Nt_Base + Nnon_Terms, Posn, 10, False);
      --# end accept;
      Sparklalr_IO.Put_Line (F, ";");
      Sparklalr_IO.Put (F, "   subtype SPGrammarNonTerminal is SPSymbol range ");
      Posn := 42;
      Print_Sym (F, Sparklalr_Common.Nt_Base + 2, Posn, 10, False);
      Sparklalr_IO.Put (F, " .. ");
      Posn := Posn + 2;
      --# accept F, 10, Posn, "Ineffective assignment here expected and OK";
      Print_Sym (F, Sparklalr_Common.Nt_Base + Nnon_Terms, Posn, 10, False);
      --# end accept;
      Sparklalr_IO.Put_Line (F, ";");
      Sparklalr_IO.New_Line (F);
      Sparklalr_IO.Put_Line (F, "end SPSymbols;");
   end Symbols_Package_Out;

   function Get_Nterms return Integer
      --# global in Nterms;
        is
   begin
      return Nterms;
   end Get_Nterms;

   function Get_Nnon_Terms return Integer
      --# global in Nnon_Terms;
        is
   begin
      return Nnon_Terms;
   end Get_Nnon_Terms;

   function Get_Term_Set (I : in Sparklalr_Common.Term_Range) return Sparklalr_Common.Id_Name
      --# global in Term_Set;
        is
   begin
      return Term_Set (I);
   end Get_Term_Set;

   function Get_Nterm_Set (I : in Sparklalr_Common.Non_Term_Range) return Sparklalr_Common.Id_Name
      --# global in Nterm_Set;
        is
   begin
      return Nterm_Set (I);
   end Get_Nterm_Set;

end Symbols_Dump;
