-- $Id: sparklalr_patab.ads 11998 2009-01-02 14:42:09Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================

with Sparklalr_IO;
--# inherit Command_Line_Options,
--#         Sparklalr_Common,
--#         Sparklalr_Goto,
--#         Sparklalr_IO,
--#         Sparklalr_Memory,
--#         Sparklalr_Parser,
--#         Symbols_Dump;

package Sparklalr_Patab
   --# own State;
is

   procedure Initialise;
   --# global out State;
   --# derives State from ;

   procedure Pa_Out (F : in Sparklalr_IO.File_Type);
   --# global in     Sparklalr_Memory.Prod_Sum;
   --#        in     Sparklalr_Memory.Stat_No;
   --#        in     Symbols_Dump.State;
   --#        in out Sparklalr_IO.Outputs;
   --#        in out Sparklalr_Parser.State;
   --#        in out State;
   --# derives Sparklalr_IO.Outputs   from *,
   --#                                     F,
   --#                                     Sparklalr_Memory.Prod_Sum,
   --#                                     Sparklalr_Memory.Stat_No,
   --#                                     Sparklalr_Parser.State,
   --#                                     State,
   --#                                     Symbols_Dump.State &
   --#         Sparklalr_Parser.State,
   --#         State                  from Sparklalr_Memory.Stat_No,
   --#                                     Sparklalr_Parser.State,
   --#                                     State;

   procedure Pa_Out_Sp (F : in Sparklalr_IO.File_Type);
   --# global in     Sparklalr_Memory.Max_Right;
   --#        in     Sparklalr_Memory.Prod_Sum;
   --#        in     Sparklalr_Memory.Stat_No;
   --#        in     Symbols_Dump.State;
   --#        in out Sparklalr_IO.Outputs;
   --#        in out Sparklalr_Parser.State;
   --#        in out State;
   --# derives Sparklalr_IO.Outputs   from *,
   --#                                     F,
   --#                                     Sparklalr_Memory.Max_Right,
   --#                                     Sparklalr_Memory.Prod_Sum,
   --#                                     Sparklalr_Memory.Stat_No,
   --#                                     Sparklalr_Parser.State,
   --#                                     State,
   --#                                     Symbols_Dump.State &
   --#         Sparklalr_Parser.State,
   --#         State                  from Sparklalr_Memory.Stat_No,
   --#                                     Sparklalr_Parser.State,
   --#                                     State;

   procedure Calc_Table_Sizes;
   --# global in     Sparklalr_Memory.Stat_No;
   --#        in     Symbols_Dump.State;
   --#        in out Sparklalr_Goto.State;
   --#        in out Sparklalr_Parser.State;
   --#        in out State;
   --# derives Sparklalr_Goto.State   from *,
   --#                                     Symbols_Dump.State &
   --#         Sparklalr_Parser.State,
   --#         State                  from Sparklalr_Memory.Stat_No,
   --#                                     Sparklalr_Parser.State,
   --#                                     State;

   procedure Optimise;
   --# global in     Command_Line_Options.State;
   --#        in     Sparklalr_Memory.Stat_No;
   --#        in     Sparklalr_Parser.State;
   --#        in out Sparklalr_IO.Outputs;
   --#        in out State;
   --# derives Sparklalr_IO.Outputs from *,
   --#                                   Command_Line_Options.State,
   --#                                   Sparklalr_Memory.Stat_No,
   --#                                   Sparklalr_Parser.State,
   --#                                   State &
   --#         State                from *,
   --#                                   Sparklalr_Memory.Stat_No,
   --#                                   Sparklalr_Parser.State;

   procedure Opt_Stats (F : in Sparklalr_IO.File_Type);
   --# global in     Sparklalr_Memory.Stat_No;
   --#        in     State;
   --#        in out Sparklalr_IO.Outputs;
   --# derives Sparklalr_IO.Outputs from *,
   --#                                   F,
   --#                                   Sparklalr_Memory.Stat_No,
   --#                                   State;

   -- Getter
   function Get_Pat_Seg_Count return Integer;
   --# global in State;

end Sparklalr_Patab;
