-- $Id: sparklalr_memory.ads 11998 2009-01-02 14:42:09Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================

with Sparklalr_Common;
--# inherit Sparklalr_Common;

package Sparklalr_Memory
   --# own Max_Right,
   --#     Prod_No,
   --#     Prod_Sum,
   --#     Stat_No;
is

   procedure Initialise;
   --# global out Max_Right;
   --#        out Prod_No;
   --#        out Prod_Sum;
   --#        out Stat_No;
   --# derives Max_Right,
   --#         Prod_No,
   --#         Prod_Sum,
   --#         Stat_No   from ;

   -- Getter
   function Get_Stat_No return Integer;
   --# global in Stat_No;

   function Get_Prod_No return  Sparklalr_Common.Production_Index;
   --# global in Prod_No;

   function Get_Prod_Sum (I : in Sparklalr_Common.Production_Index; J : in Positive) return Integer;
   --# global in Prod_Sum;

   function Get_Max_Right return Integer;
   --# global in Max_Right;

private

   type Symbol_Set_T is array (Sparklalr_Common.Sym_Range) of Boolean;

   procedure Set_Union (A : in out Symbol_Set_T; B : in Symbol_Set_T; Elements_Added_To_A : out Boolean);
   --# derives A,
   --#         Elements_Added_To_A from A,
   --#                                  B;

   function Get_Symbol_Set (Symbol_Set : in Symbol_Set_T; I : in Sparklalr_Common.Sym_Range) return Boolean;

   subtype One_Two is Positive range 1 .. 2;
   type Prod_Sum_Row_T is array (One_Two) of Integer;
   type Prod_Sum_T is array (Sparklalr_Common.Production_Index) of Prod_Sum_Row_T;


   Stat_No   : Integer;
   Prod_No   : Sparklalr_Common.Production_Index;
   Prod_Sum  : Prod_Sum_T;
   Max_Right : Integer;

   procedure Set_Stat_No (Val : in Integer);
   --# global out Stat_No;
   --# derives Stat_No from Val;

   procedure Set_Prod_No (Val : in Sparklalr_Common.Production_Index);
   --# global out Prod_No;
   --# derives Prod_No from Val;

   procedure Set_Prod_Sum (I : in Sparklalr_Common.Production_Index; J : in One_Two; Val : in Integer);
   --# global in out Prod_Sum;
   --# derives Prod_Sum from *,
   --#                       I,
   --#                       J,
   --#                       Val;

   procedure Set_Max_Right (Val : in Integer);
   --# global out Max_Right;
   --# derives Max_Right from Val;

end Sparklalr_Memory;
