-- $Id: sparklalr_conflict.ads 11998 2009-01-02 14:42:09Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================

with Sparklalr_IO;
--# inherit Command_Line_Options,
--#         Sparklalr_Common,
--#         Sparklalr_IO,
--#         Sparklalr_Level,
--#         Sparklalr_Memory,
--#         Sparklalr_Memory.Dump,
--#         Sparklalr_Parser,
--#         Sparklalr_Patab,
--#         Symbols_Dump;

package Sparklalr_Conflict
   --# own State;
is

   procedure Initialise;
   --# global out State;
   --# derives State from ;

   procedure Print_Conflicts (F : in Sparklalr_IO.File_Type);
   --# global in     Sparklalr_Memory.Dump.State;
   --#        in     Sparklalr_Memory.Stat_No;
   --#        in     Sparklalr_Parser.State;
   --#        in     State;
   --#        in     Symbols_Dump.State;
   --#        in out Sparklalr_IO.Outputs;
   --# derives Sparklalr_IO.Outputs from *,
   --#                                   F,
   --#                                   Sparklalr_Memory.Dump.State,
   --#                                   Sparklalr_Memory.Stat_No,
   --#                                   Sparklalr_Parser.State,
   --#                                   State,
   --#                                   Symbols_Dump.State;

   procedure Conflict_Stats (F : in Sparklalr_IO.File_Type);
   --# global in     State;
   --#        in out Sparklalr_IO.Outputs;
   --# derives Sparklalr_IO.Outputs from *,
   --#                                   F,
   --#                                   State;

   procedure Dump_Conflicts (F : in Sparklalr_IO.File_Type; Nstate : in Integer);
   --# global in     State;
   --#        in     Symbols_Dump.State;
   --#        in out Sparklalr_IO.Outputs;
   --# derives Sparklalr_IO.Outputs from *,
   --#                                   F,
   --#                                   Nstate,
   --#                                   State,
   --#                                   Symbols_Dump.State;

   procedure Parse_Action_Generation (F : in Sparklalr_IO.File_Type);
   --# global in     Command_Line_Options.State;
   --#        in     Sparklalr_Level.State;
   --#        in     Sparklalr_Memory.Stat_No;
   --#        in     Symbols_Dump.State;
   --#        in out Sparklalr_IO.Outputs;
   --#        in out Sparklalr_Memory.Dump.State;
   --#        in out Sparklalr_Parser.State;
   --#        in out Sparklalr_Patab.State;
   --#        in out State;
   --# derives Sparklalr_IO.Outputs        from *,
   --#                                          Command_Line_Options.State,
   --#                                          F,
   --#                                          Sparklalr_Level.State,
   --#                                          Sparklalr_Memory.Dump.State,
   --#                                          Sparklalr_Memory.Stat_No,
   --#                                          Sparklalr_Parser.State,
   --#                                          Sparklalr_Patab.State,
   --#                                          Symbols_Dump.State &
   --#         Sparklalr_Memory.Dump.State,
   --#         Sparklalr_Parser.State,
   --#         Sparklalr_Patab.State,
   --#         State                       from *,
   --#                                          Command_Line_Options.State,
   --#                                          Sparklalr_Level.State,
   --#                                          Sparklalr_Memory.Dump.State,
   --#                                          Sparklalr_Memory.Stat_No,
   --#                                          Sparklalr_Parser.State,
   --#                                          Symbols_Dump.State;

end Sparklalr_Conflict;
