-- $Id: sparklalr_common.adb 11998 2009-01-02 14:42:09Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================

package body Sparklalr_Common is

   procedure Put_N_Chars (Fil : in Sparklalr_IO.File_Type; C : in Character; N : in Natural) is
      I : Integer := 1;
   begin
      while I <= N loop
         Sparklalr_IO.Put_Char (Fil, C);
         I := I + 1;
      end loop;
   end Put_N_Chars;

   procedure Print
     (F       : in Sparklalr_IO.File_Type;
      String1 : in String;
      Posn    : in out Integer;
      Tab     : in Integer;
      Comm    : in Boolean)
   is
      I, J : Integer;
   begin
      I := String1'Length;
      while String1 (I) = ' ' loop
         I := I - 1;
      end loop;
      if (Posn + I) > (Page_Width - 2) then
         Sparklalr_IO.New_Line (F);
         if Comm then
            Sparklalr_IO.Put (F, "--");
            Put_N_Chars (F, ' ', Tab - 2);
         else
            Put_N_Chars (F, ' ', Tab);
         end if;
         Posn := I + Tab;
      else
         Posn := Posn + I;
      end if;
      J := 1;
      while J <= I loop
         Sparklalr_IO.Put_Char (F, String1 (J));
         J := J + 1;
      end loop;
   end Print;

   procedure Print2
     (F       : in Sparklalr_IO.File_Type;
      String1 : in String;
      String2 : in String;
      Posn    : in out Integer;
      Tab     : in Integer;
      Comm    : in Boolean)
   is
      I, J, K : Integer;
   begin
      I := String1'Length;
      while String1 (I) = ' ' loop
         I := I - 1;
      end loop;
      J := String2'Length;
      while String2 (J) = ' ' loop
         J := J - 1;
      end loop;
      if ((Posn + I) + J) > (Page_Width - 2) then
         Sparklalr_IO.New_Line (F);
         if Comm then
            Sparklalr_IO.Put (F, "--");
            Put_N_Chars (F, ' ', Tab - 2);
         else
            Put_N_Chars (F, ' ', Tab);
         end if;
         Posn := (I + J) + Tab;
      else
         Posn := (Posn + I) + J;
      end if;
      K := 1;
      while K <= I loop
         Sparklalr_IO.Put_Char (F, String1 (K));
         K := K + 1;
      end loop;
      K := 1;
      while K <= J loop
         Sparklalr_IO.Put_Char (F, String2 (K));
         K := K + 1;
      end loop;
   end Print2;

   function Code (Sr : in Action_Type; C : in Integer) return Integer
      -- ENCODES PARSING ACTION INTO INTEGER REPRESENTATION
        is
      Result_Code : Integer;
   begin
      if Sr = Reduce then
         Result_Code := C;
      else
         if Sr = Shift then
            Result_Code := Prod_Lim + C;
         else
            Result_Code := 0;
         end if;
      end if;
      return Result_Code;
   end Code;

   function Decode (C : in Integer) return Integer is
      Result_Decode : Integer;
   begin
      if C > Prod_Lim then
         Result_Decode := C - Prod_Lim;
      else
         Result_Decode := C;
      end if;
      return Result_Decode;
   end Decode;

end Sparklalr_Common;
