-- $Id: sparklalr_char_class.adb 11998 2009-01-02 14:42:09Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================

package body Sparklalr_Char_Class is

   type Charmap_Array_T is array (Character) of Char_Class;
   Charmap : Charmap_Array_T;

   procedure Initialise is
      Ordmaxchar : constant := 255; -- ORDINAL OF MAX CHARACTER
      Uppercase  : constant String := "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
      Lowercase  : constant String := "abcdefghijklmnopqrstuvwxyz";
      Special    : constant String := "&:;^|(,=_ ";
      Nspecial   : constant := 10;

      subtype Letters_Range is Positive range 1 .. 26;
      subtype Letters_T is String (Letters_Range);
      Letters : Letters_T;

      subtype Sp_Range is Positive range 1 .. Nspecial;
      subtype Sp_T is String (Sp_Range);
      Sp : Sp_T;

      subtype Otherchar_Range is Character range Character'Val (0) .. Character'Val (Ordmaxchar);
      subtype Digit_Range is Character range Character'Val (Character'Pos ('0')) .. Character'Val (Character'Pos ('9'));

   begin
      Charmap := Charmap_Array_T'(others => None);
      for Ch in Otherchar_Range loop
         Charmap (Ch) := Otherchar;
      end loop;
      for Ch in Digit_Range loop
         Charmap (Ch) := Digit;
      end loop;
      Letters := Uppercase;
      for I in Letters_Range loop
         Charmap (Letters (I))  := Letter;
      end loop;
      Letters := Lowercase;
      for I in Letters_Range loop
         Charmap (Letters (I))  := Letter;
      end loop;
      Sp                 := Special;
      Charmap (Sp (1))   := Ampchar;
      Charmap (Sp (2))   := Colonchar;
      Charmap (Sp (3))   := Scolonchar;
      Charmap (Sp (4))   := Uparrowchar;
      Charmap (Sp (5))   := Uparrowchar;
      Charmap (Sp (6))   := Lparenchar;
      Charmap (Sp (7))   := Commachar;
      Charmap (Sp (8))   := Equalchar;
      Charmap (Sp (9))   := Underscore;
      Charmap (Sp (10))  := Blankchar;
   end Initialise;

   function Get_Charmap (C : in Character) return Char_Class is
   begin
      return Charmap (C);
   end Get_Charmap;

end Sparklalr_Char_Class;
