-- $Id: command_line_options.ads 11998 2009-01-02 14:42:09Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================

with Sparklalr_IO;
--# inherit Sparklalr_IO;

package Command_Line_Options
   --# own State;
is

   type Debug_Level_Range is range 1 .. 9;

   procedure Get_Options;
   --# global in     Sparklalr_IO.State;
   --#           out State;
   --# derives State from Sparklalr_IO.State;

   -- Getter
   function Get_File_Name return  Sparklalr_IO.File_Name;
   --# global in State;

   function Get_Verbose return Boolean;
   --# global in State;

   function Get_Debug_Level (Level : in Debug_Level_Range) return Boolean;
   --# global in State;

   function Get_Dump_Mem return Boolean;
   --# global in State;

   function Get_Parser return Boolean;
   --# global in State;

   function Get_Self_Pack return Boolean;
   --# global in State;

   function Get_Multi_Comp return Boolean;
   --# global in State;

end Command_Line_Options;
