-- $Id: sparkformatcommandlinedata.ads 11376 2008-10-08 11:09:31Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


with EStrings,
     ExaminerConstants;

--# inherit EStrings,
--#         ExaminerConstants,
--#         FileSystem;

package SparkFormatCommandLineData
--# own Content : CommandLineContents;
is

   MetaFileExtension : constant EStrings.T :=
      EStrings.T'(3,
                                      EStrings.Contents'('s', 'm', 'f', others => ' '));

   type SourceFileEntry is record
      SourceFileName  : EStrings.T;
   end record;

   subtype SourceFileCounts is Integer range
      0 .. ExaminerConstants.MaxFilesOnCommandLine;
   subtype SourceFilePositions is Integer range
      0 .. ExaminerConstants.MaxFilesOnCommandLine;
   type SourceFileLists is array (SourceFilePositions) of SourceFileEntry;

   type ExpandOrCompress is (Expand, Compress);
   type FunctionModeType is (InMode, Unmoded);

   type CommandLineContents is record
      Valid                : Boolean;
      SourceExtension      : EStrings.T;
      ExcludeExport        : EStrings.T;
      NumberSource         : SourceFileCounts;
      SourceFileList       : SourceFileLists;
      Operation            : ExpandOrCompress;
      AddModes             : Boolean;
      GlobalIndent         : Natural;
      ExportIndent         : Natural;
      ImportIndent         : Natural;
      InheritIndent        : Natural;
      OwnIndent            : Natural;
      RefinementIndent     : Natural;
      ConstituentIndent    : Natural;
      InitializationIndent : Natural;
      PropertiesIndent     : Natural;
      SeparatorIndent      : Natural;
      AlphabeticOrdering   : Boolean;
      Help                 : Boolean;
      Version              : Boolean;
      DefaultFunctionMode  : FunctionModeType;
   end record;

   Content : CommandLineContents;

   -- 0 is used as a sentinel value to mean "inline" output
   -- of globals, imports, exports and separators.
   Inline : constant Natural := 0;

   procedure Initialize;
   --# global out Content;
   --# derives Content from ;

end SparkFormatCommandLineData;
