-- $Id: sparkformatcommandlinedata.adb 11376 2008-10-08 11:09:31Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


package body SparkFormatCommandLineData
is

   Ada_Extension : constant EStrings.T :=
     EStrings.T'
      (3,
       EStrings.Contents'('a', 'd', 'a', others => ' '));

   procedure Initialize is
   begin
      Content := CommandLineContents'
         (Valid => True,
          SourceExtension  => Ada_Extension,
          ExcludeExport    => EStrings.EmptyString,
          NumberSource => 0,
          SourceFileList =>
            SourceFileLists'(others => SourceFileEntry'
                             (SourceFileName => EStrings.EmptyString)),
         Operation => Compress,
         AddModes => False,
         GlobalIndent         => Inline,
         ExportIndent         => Inline,
         ImportIndent         => Inline,
         InheritIndent        => Inline,
         OwnIndent            => Inline,
         RefinementIndent     => Inline,
         ConstituentIndent    => Inline,
         InitializationIndent => Inline,
         SeparatorIndent      => Inline,
         PropertiesIndent     => Inline,
         AlphabeticOrdering   => False,
         Help => False,
         Version => False,
         DefaultFunctionMode => Unmoded);
   end Initialize;

end SparkFormatCommandLineData;
