%  $Id: simplify.pro 12833 2009-03-31 10:31:59Z Dean Kuo $
%-------------------------------------------------------------------------------
%  (C) Praxis High Integrity Systems Limited
%-------------------------------------------------------------------------------
% 
%  The SPARK toolset is free software; you can redistribute it and/or modify it
%  under terms of the GNU General Public License as published by the Free
%  Software Foundation; either version 3, or (at your option) any later
%  version. The SPARK toolset is distributed in the hope that it will be
%  useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
%  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
%  Public License for more details. You should have received a copy of the GNU
%  General Public License distributed with the SPARK toolset; see file
%  COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
%  the license.
% 
%===============================================================================

%###############################################################################
% PURPOSE
%-------------------------------------------------------------------------------
% Further simplification routines.
%###############################################################################




%###############################################################################
% MODULE
%###############################################################################

%###############################################################################
% DEPENDENCIES
%###############################################################################

%###############################################################################
% TYPES
%###############################################################################

%###############################################################################
% DATA
%###############################################################################

%###############################################################################
% PREDICATES
%###############################################################################

% SIMPLIFY - top-level checker command.
restructure_vc(D) :-
   movenots(D);
   split_hyps(D);
   split_concs(D);
   do_implication(D);
   equivalence(D).

restructure_vc(_) :-
    !.

%-------------------------------------------------------------------------------

% MOVENOTS - move nots as far into expressions as possible.
movenots(D) :-
   retractall(hn(_)),
   assertz(hn(1)),
   repeat,
      hn(N),
      (
         gethyp(N,H),
         negin(H,H1),
         force_simplify(H1, H2),
         add_hyp_with_id(H2, x, N),
         log_negation_simplification(N, H, H2,D)
      ;
         true
      ),
      M is N+1,
      retract(hn(N)),
      assertz(hn(M)),
      bigger_than_all_hyps(M),
      !,
      fail.

%-------------------------------------------------------------------------------

bigger_than_all_hyps(M) :-
        get_hyp(_, _, N),
        N>=M,
        !,
        fail.

bigger_than_all_hyps(_) :-
    !.

%-------------------------------------------------------------------------------

force_simplify(X, Y) :-
        simplification_is_on,
        simplify(X, Y),
        !.

force_simplify(X, X) :- !.

%-------------------------------------------------------------------------------

% GETHYP(N,H) - instantiates H to the Nth hypothesis & retracts it.
gethyp(N,H) :-
   get_hyp(H, x, N),
   prune_hyp(H, x, N),
   !.

%-------------------------------------------------------------------------------

log_negation_simplification(_N, H, H, _D) :- !.
log_negation_simplification(N, _OLD, NEW, D) :-
        assert_log_fact(restructured, [N, NEW, D]),
        !.

%-------------------------------------------------------------------------------

% SPLIT_HYPS - split conjunction hypotheses into two or more hypotheses.
split_hyps(D) :-
   prune_hyp(A and B, x, N),
   add_hyp(A, x, Na),
   add_hyp(B, x, Nb),
   assert_log_fact(hyp_split, [N, [Na, A], [Nb, B], D]),
   !,
   % Try again in case either or A or B are also a conjunction
   split_hyps(D).

%-------------------------------------------------------------------------------

% SPLIT_CONCS - split conjunction conclusions into separate conclusions.
split_concs(D) :-
   prune_conc(A and B, x, N),
   prune_all_concs(_, _, N),
   add_conc(A, x, Na),
   add_conc(B, x, Nb),
   assert_log_fact(conc_split, [N, [Na, A], [Nb, B], D]),
   !,
   % Try again in case either or A or B are also a conjunction
   split_concs(D).

%-------------------------------------------------------------------------------

% DO_IMPLICATION - given "A" and "A -> B", add "B" as a hypothesis;
%                  given "not B" and "A -> B", add "not A" as a hypothesis.


do_implication(D) :-
   get_hyp(A -> B, x, Nab),
   get_hyp(A, x, Na),
   add_hyp(B, x, Nb),
   assert_log_fact(forwardchain, [Nab, Na, Nb, B, D]),
   fail.

do_implication(D) :-
   get_hyp(A -> B, x, Nab),
   get_hyp((not B), x, Nb),
   negin((not A),C),
   add_hyp(C, x, Na),
   assert_log_fact(backchain, [Nab, Nb, Na, C, D]),
   fail.

%-------------------------------------------------------------------------------

% EQUIVALENCE - given "A" and "A <-> B" or "B <-> A", add "B";
%               given "not A" and "A <-> B" or "B <-> A", add "not B"
equivalence(D) :-
   get_hyp(A <-> B, x, Nab),
   get_hyp(A, x, Na),
   add_hyp(B, x, Nb),
   assert_log_fact(forwardchain, [Nab, Na, Nb, B, D]),
   fail.

equivalence(D) :-
   get_hyp(A <-> B, x, Nab),
   get_hyp(B, x, Nb),
   add_hyp(A, x, Na),
   assert_log_fact(forwardchain, [Nab, Nb, Na, A, D]),
   fail.

equivalence(D) :-
   get_hyp(A <-> B, x, Nab),
   get_hyp(not(A), x, Na),
   negin(not(B),C),
   add_hyp(C, x, Nb),
   assert_log_fact(backchain, [Nab, Na, Nb, C, D]),
   fail.

equivalence(D) :-
   get_hyp(A <-> B, x, Nab),
   get_hyp(not(B), x, Nb),
   negin(not(A),C),
   add_hyp(C, x, Na),
   assert_log_fact(backchain, [Nab, Nb, Na, C, D]),
   fail.

%###############################################################################
% END-OF-FILE
