%  $Id: simplifier.pro 12699 2009-03-12 14:57:28Z dean kuo $
%-------------------------------------------------------------------------------
%  (C) Praxis High Integrity Systems Limited
%-------------------------------------------------------------------------------
% 
%  The SPARK toolset is free software; you can redistribute it and/or modify it
%  under terms of the GNU General Public License as published by the Free
%  Software Foundation; either version 3, or (at your option) any later
%  version. The SPARK toolset is distributed in the hope that it will be
%  useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
%  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
%  Public License for more details. You should have received a copy of the GNU
%  General Public License distributed with the SPARK toolset; see file
%  COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
%  the license.
% 
%===============================================================================


%###############################################################################
% PURPOSE
%-------------------------------------------------------------------------------
% Top level file, to build the Simplifier without flexlm.
%###############################################################################


%###############################################################################
% MODULE
%###############################################################################


%###############################################################################
% DEPENDENCIES
%###############################################################################


%###############################################################################
% TYPES
%###############################################################################


%###############################################################################
% DATA
%###############################################################################


%###############################################################################
% PREDICATES
%###############################################################################


%===============================================================================
% LOAD SICSTUS LIBRARIES BEFORE DYNAMIC CHANGES
%===============================================================================
:- use_module('librarypredicates.pro').
%===============================================================================


%===============================================================================
% DYNAMIC FEATURES PRE-LOAD
%===============================================================================
:- use_module('settings.pro',
              [declare_settings/0]).
:- declare_settings.

:- use_module('opdeclar.pro',
              [declare_operators/0,
               hide_operators/0]).
:- declare_operators.
%===============================================================================


%===============================================================================
% FIXED SYSTEM CONFIGURATION
%-------------------------------------------------------------------------------
% This information will be the same for every execution of the tool.
%===============================================================================
:- use_module('datasystem.pro',
              [add_system_toolname/1]).

:- add_system_toolname('Simplifier').
%===============================================================================


%===============================================================================
% LOAD SYSTEM
%===============================================================================
:- include('mainsimplifier.pro').
%===============================================================================


%===============================================================================
% runtime_entry(start).
%-------------------------------------------------------------------------------
% This is a special Sicstus predicate, which will be automatically invoked
% when restoring a saved state. It is the top level, or main, predicate.
%===============================================================================

runtime_entry(start):-
    simplifier_main,
    halt(0),
    !.
%===============================================================================


%===============================================================================
% DYNAMIC FEATURES POST-LOAD
%===============================================================================

% _After_ all dynamic predicates have been introduced, we need to disable
% "dynamic" as an operator in case a user has an fdl entity called
% "dynamic". Same goes for the other predefined prolog operators that might
% look like fdl identifiers. See the sicstus manual section "Standard
% Operators"
:- hide_operators.
%===============================================================================


%===============================================================================
% SAVE SYSTEM AND HALT
%===============================================================================
:- save_program('spadesimp.sav').
:- halt.
%===============================================================================


%###############################################################################
% END-OF-FILE
