%  $Id: mainsimplifier.pro 12990 2009-04-15 13:26:41Z Bill Ellis $
%-------------------------------------------------------------------------------
%  (C) Praxis High Integrity Systems Limited
%-------------------------------------------------------------------------------
% 
%  The SPARK toolset is free software; you can redistribute it and/or modify it
%  under terms of the GNU General Public License as published by the Free
%  Software Foundation; either version 3, or (at your option) any later
%  version. The SPARK toolset is distributed in the hope that it will be
%  useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
%  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
%  Public License for more details. You should have received a copy of the GNU
%  General Public License distributed with the SPARK toolset; see file
%  COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
%  the license.
% 
%===============================================================================

%###############################################################################
% PURPOSE
%-------------------------------------------------------------------------------
% Loads the common core of modules as required by the Simplifier. Note that
% this code does not reside inside a module. It is included by one of the
% top level build files.
%###############################################################################

%###############################################################################
% DEPENDENCIES
%###############################################################################

%###############################################################################
% TYPES
%###############################################################################

%###############################################################################
% DATA
%###############################################################################

%###############################################################################
% PREDICATES
%###############################################################################

%===============================================================================
% LOAD MODULES
%===============================================================================




:- use_module('dataswitches.pro').
:- use_module('datadatafiles.pro').
:- use_module('datasystem.pro').
:- use_module('datarules.pro').
:- use_module('datadeclarations.pro').
:- use_module('datavcg.pro').
:- use_module('datapfs.pro').
:- use_module('dataprovenance.pro').
:- use_module('datahyp.pro').
:- use_module('dataconc.pro').
:- use_module('dataprovedconc.pro').
:- use_module('datasubsthyp.pro').

:- use_module('newutilities.pro').
:- use_module('ioutilities.pro').
:- use_module('loadswitches.pro').
:- use_module('loaddatafiles.pro').
:- use_module('loadrules.pro').
:- use_module('loadsystem.pro').
:- use_module('loaddeclarations.pro').
:- use_module('loadprovenance.pro').
:- use_module('loadvcg.pro').
:- use_module('loadpfs.pro').
:- use_module('processrules.pro').
:- use_module('simplifier_ioutilities.pro').

:- use_module('../common/versioning/version.pro').

%===============================================================================
% INCLUDE CODE
%===============================================================================


portray_message(informational, _).

:- use_module('librarypredicates.pro',
              [file_exists/1,
               rename_file/2,
               last/2,
               remove_dups/2,
               reverse/2,
               process_create/3,
               process_wait/2,
               datime/1]).

:- include('utilities.pro').
:- include('dynamics.pro').
:- include('portray.pro').
:- include('deduction.pro').
:- include('newded.pro').
:- include('inferenc2.pro').
:- include('schedulesimplification.pro').
:- include('records2.pro').
:- include('simp.pro').
:- include('simplify.pro').
:- include('simpvc.pro').
:- include('quant.pro').
:- include('standard.pro').
:- include('typecheck5.pro').
:- include('userules.pro').
:- include('aritheval.pro').
:- include('writevc.pro').
:- include('makelog.pro').

%===============================================================================
% simplifier_main.
%-------------------------------------------------------------------------------
% This predicate sequences all of the actions of the Simplifier.
%===============================================================================

simplifier_main :-

    %Initialise system information
    %----------------------------
    load_system,

    %Load the switches provided by the user
    %--------------------------------------
    load_switches,

    %Process help or version request
    %-------------------------------
    handle_information_request,

    %Load the input files
    %--------------------
    load_data_files,

    %Begin system operation
    %----------------------

    %Display the header to the screen.
    display_header(user_output),

    %Load the provenance for this proof problem.
    load_provenance,

    %Load the declarations for this proof problem.
    load_declarations,

    %Load available rules.
    load_rules,


    presimplify,
    format('\n\n\n', []),
    process_action,
    format('\n', []),
    !.

%-------------------------------------------------------------------------------

simplifier_main :-
    format('\n\n', []),
    throw_error('The Simplifier failed.\n', []).

%-------------------------------------------------------------------------------

presimplify:-
    retrieve_proof_file(ProofFile_Atom),
    convert_file_for_display(ProofFile_Atom, DisplayProofFile_Atom),
    write('Processing '),
    write(DisplayProofFile_Atom),
    write(' ...'),
    nl,
    do_rule_substitutions0,

    write_log_file_banner,
    write_rules_read,

    % First load the vcs.
    new_load_vcg,

    retrieve_simplified_proof_file(SimplifiedProofFile_Atom),
    open(SimplifiedProofFile_Atom, write, SimplifiedProofFile_Stream),
    display_banner(SimplifiedProofFile_Stream),

    % Then simplify the vcs.
    perform_simplification(SimplifiedProofFile_Stream),

    close(SimplifiedProofFile_Stream),

    write_overall_rule_summary,
    close_log_file,
    (
        typecheck_only(on)
    ;
        typecheck_only(off),
        do_wrap_lines
    ),
    maybe_issue_syntax_reminder,
    !.


new_load_vcg:-
    get_provenance_proof_file_kind(verification_conditions),
    load_vcg,
    !.

new_load_vcg:-
    get_provenance_proof_file_kind(path_functions),
    load_pfs,
    !.

new_load_vcg:-
    throw_error('The Simplifier failed to determine proof file kind.\n', []).

%-------------------------------------------------------------------------------

process_action:-
    get_switch_typecheck_only(on),
    format('Typechecking only - no simplification has been performed', []),
    !.

process_action:-
    get_switch_typecheck_only(off),
    retrieve_simplified_proof_file(SimplifiedProofFile_Atom),
    convert_file_for_display(SimplifiedProofFile_Atom, DisplaySimplifiedProofFile_Atom),
    format('Automatic simplification completed.\n\n', []),
    format('Simplified output sent to ~w.',[DisplaySimplifiedProofFile_Atom]),
    !.

%===============================================================================
% handle_information_request.
%-------------------------------------------------------------------------------
% If the user has requested information, rather than simplification, then
% report the information and exit.
%===============================================================================

% Explicitly requested help.
handle_information_request:-
    get_switch_help(on),
    display_help(user_output),
    halt(0),
    !.

% Provided zero arguments, so implicitly requested help.
handle_information_request:-
    get_switch_empty(on),
    display_help(user_output),
    halt(0),
    !.

% Requested version.
handle_information_request:-
    get_switch_version(on),
    display_header(user_output),
    halt(0),
    !.

% None of the above. Continue as normal.
handle_information_request:-
    !.
%===============================================================================








var_const(VarId_Atom, TypeId_Atom, v):-
    get_declarations_variable(TypeId_Atom,
                              VarId_Atom).

var_const(ConstId_Atom, TypeId_Atom, c):-
    get_declarations_constant(TypeId_Atom,
                              ConstId_Atom).

%###############################################################################
% END-OF-FILE
