%  $Id: loadsystem.pro 12703 2009-03-12 16:38:35Z Bill Ellis $
%-------------------------------------------------------------------------------
%  (C) Praxis High Integrity Systems Limited
%-------------------------------------------------------------------------------
% 
%  The SPARK toolset is free software; you can redistribute it and/or modify it
%  under terms of the GNU General Public License as published by the Free
%  Software Foundation; either version 3, or (at your option) any later
%  version. The SPARK toolset is distributed in the hope that it will be
%  useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
%  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
%  Public License for more details. You should have received a copy of the GNU
%  General Public License distributed with the SPARK toolset; see file
%  COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
%  the license.
% 
%===============================================================================

%###############################################################################
% PURPOSE
%-------------------------------------------------------------------------------
% Set information that is specific to the particular build or running
% process.
%###############################################################################

%###############################################################################
%MODULE
%###############################################################################
:- module(loadsystem, [load_system/0]).

%###############################################################################
%DEPENDENCIES
%###############################################################################

:- use_module('newutilities.pro',
              [fetch_date_and_time/2]).

:- use_module('datasystem.pro',
              [add_system_start_date_time/2]).

%###############################################################################
%TYPES
%###############################################################################

%###############################################################################
%DYNAMICS
%###############################################################################

%###############################################################################
%PREDICATES
%###############################################################################

%===============================================================================
% load_system.
%-------------------------------------------------------------------------------
% Sets configuration items that are specific to this particular process.
%===============================================================================

load_system:-

    %Determine and store the time the system was started. This should be
    %the only point that the system clock is inspected.
    fetch_date_and_time(Date_Atom, Time_Atom),
    add_system_start_date_time(Date_Atom, Time_Atom),
    !.

%###############################################################################
%END-OF-FILE
