%  $Id: dataprovenance.pro 12607 2009-02-27 09:29:23Z Bill Ellis $
%-------------------------------------------------------------------------------
%  (C) Praxis High Integrity Systems Limited
%-------------------------------------------------------------------------------
% 
%  The SPARK toolset is free software; you can redistribute it and/or modify it
%  under terms of the GNU General Public License as published by the Free
%  Software Foundation; either version 3, or (at your option) any later
%  version. The SPARK toolset is distributed in the hope that it will be
%  useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
%  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
%  Public License for more details. You should have received a copy of the GNU
%  General Public License distributed with the SPARK toolset; see file
%  COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
%  the license.
% 
%===============================================================================


%###############################################################################
% PURPOSE
%-------------------------------------------------------------------------------
% Provides access to all information related to the provenance of the target
% proof problem.
%###############################################################################


%###############################################################################
% MODULE
%###############################################################################

:- module(dataprovenance, [get_provenance_framework/1,
                           add_provenance_framework/1,
                           get_provenance_proof_file_kind/1,
                           add_provenance_proof_file_kind/1,
                           get_provenance_date_time/2,
                           add_provenance_date_time/2,
                           get_provenance_banner/1,
                           add_provenance_banner/1,
                           get_provenance_subprogram_identifier/1,
                           add_provenance_subprogram_identifier/1,



                           path_functions/0,

                           save_dataprovenance/0]).


%###############################################################################
% DEPENDENCIES
%###############################################################################

:- use_module('dataformats.pro', [add_state/2,
                                 add_type/2]).
:- use_module('ioutilities.pro', [write_terms_to_file/2]).
:- use_module('datadatafiles.pro', [must_get_datafiles_debug/2]).


%###############################################################################
% TYPES
%###############################################################################

:- add_type('Framework',
            [spark,
             pascal]).


%###############################################################################
% DATA
%###############################################################################

:- add_state(get_provenance_framework,
             get_provenance_framework('Framework')).
:- dynamic(get_provenance_framework/1).

:- add_state(get_provenance_proof_file_kind,
             get_provenance_proof_file_kind('ProofFileKind')).
:- dynamic(get_provenance_proof_file_kind/1).

:- add_state(get_provenance_date_time,
             get_provenance_date_time('Date_Atom', 'Time_Atom')).
:- dynamic(get_provenance_date_time/2).

:- add_state(get_provenance_banner,
             get_provenance_banner('Line_AtomList')).
:- dynamic(get_provenance_banner/1).

:- add_state(get_provenance_subprogram_identifier,
             get_provenance_subprogram_identifier('SubprogramIdentifier_Atom')).
:- dynamic(get_provenance_subprogram_identifier/1).


%###############################################################################
% PREDICATES
%###############################################################################


%===============================================================================
% Add.
%===============================================================================

add_provenance_framework(Framework):-
    assert(get_provenance_framework(Framework)),
    !.

add_provenance_proof_file_kind(ProofFileKind):-
    assert(get_provenance_proof_file_kind(ProofFileKind)),
    !.

add_provenance_date_time(Date_Atom, Time_Atom):-
    assert(get_provenance_date_time(Date_Atom, Time_Atom)),
    !.

add_provenance_banner(Line_AtomList):-
    assert(get_provenance_banner(Line_AtomList)),
    !.

add_provenance_subprogram_identifier(SubprogramIdentifier_Atom):-
    assert(get_provenance_subprogram_identifier(SubprogramIdentifier_Atom)),
    !.
%===============================================================================


%===============================================================================
% save_dataprovenance.
%===============================================================================

save_dataprovenance:-
    must_get_datafiles_debug(dataprovenance, DebugFile_Atom),
    write_terms_to_file(DebugFile_Atom,
                        [dataprovenance:get_provenance_framework/1,
                         dataprovenance:get_provenance_proof_file_kind/2,
                         dataprovenance:get_provenance_date_time/2,
                         dataprovenance:get_provenance_banner/1,
                         dataprovenance:get_provenance_subprogram_identifier/1]),

    !.
%===============================================================================


%===============================================================================
% Refactor.
%===============================================================================

path_functions:-
    get_provenance_proof_file_kind(path_functions),
    !.

%===============================================================================


%###############################################################################
% END-OF-FILE
