%  $Id: datapfs.pro 12106 2009-01-13 10:11:30Z Bill Ellis $
%-------------------------------------------------------------------------------
%  (C) Praxis High Integrity Systems Limited
%-------------------------------------------------------------------------------
% 
%  The SPARK toolset is free software; you can redistribute it and/or modify it
%  under terms of the GNU General Public License as published by the Free
%  Software Foundation; either version 3, or (at your option) any later
%  version. The SPARK toolset is distributed in the hope that it will be
%  useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
%  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
%  Public License for more details. You should have received a copy of the GNU
%  General Public License distributed with the SPARK toolset; see file
%  COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
%  the license.
% 
%===============================================================================


%###############################################################################
% PURPOSE
%-------------------------------------------------------------------------------
% Provides access to all information related to pfs. This information will
% be retrieved from the provided pfs file. 
%###############################################################################


%###############################################################################
% MODULE
%###############################################################################

:- module(datapfs, [get_pfs_statement/2,
                    add_pfs_statement/2,
                    get_pfs_successor_statement/3,
                    add_pfs_successor_statement/3,
                    get_pfs_pf/4,
                    add_pfs_pf/4,
                    get_pfs_traversal_condition/3,
                    add_pfs_traversal_condition/3,
                    get_pfs_action/2,
                    add_pfs_action/2,

                    save_datapfs/0]).


%###############################################################################
% DEPENDENCIES
%###############################################################################

:- use_module('dataformats.pro', [add_state/2,
                                 add_type/2]).
:- use_module('ioutilities.pro', [write_terms_to_file/2]).
:- use_module('datadatafiles.pro', [must_get_datafiles_debug/2]).


%###############################################################################
% TYPES
%###############################################################################

% Statement: start      2 successor(s)
% Statement: line 48     2 successor(s)
:- add_type('PFTraceStatement',
            [statement('PFPositionFrom', 'Successors_Int')]).

:- add_type('PFPositionFrom',
            [start,
             line('Int')]).

% Successor statement: line 32.
% Successor statement:  finish.
:- add_type('PFTraceSuccessorStatement',
            [successor_statement('PFPositionTo')]).

:- add_type('PFPositionTo',
            [finish,
             line('Int')]).


%###############################################################################
% DATA
%###############################################################################

% A pfs file has a number of statement lines.
% Each statement has a number of successors.
% Each successor has a number of path functions.
% Each path function has a number of traversal conditions and an action.

:- add_state(get_pfs_statement,
             get_pfs_statement('StatementId_Atom', 'PFTraceStatement')).
:- dynamic(get_pfs_statement/2).

:- add_state(get_pfs_successor_statement,
             get_pfs_successor_statement('SuccessorStatementId_Atom',
                                         'PFTraceSuccessorStatement',
                                         'ParentStatementId_Atom')).
:- dynamic(get_pfs_successor_statement/3).

:- add_state(get_pfs_pf,
             get_pfs_pf('PFId_Atom',
                        'Order_Int',
                        'Number_Int',
                        'ParentSuccessorStatementId_Atom')).
:- dynamic(get_pfs_pf/4).

:- add_state(get_pfs_traversal_condition,
             get_pfs_traversal_condition('Number_Int', 'TravCond_Term', 'ParentPFId_Atom')).
:- dynamic(get_pfs_traversal_condition/3).

:- add_state(get_pfs_action,
             get_pfs_action('Action_Term', 'ParentPFId_Atom')).
:- dynamic(get_pfs_action/2).


%###############################################################################
% PREDICATES
%###############################################################################


%===============================================================================
% Add.
%===============================================================================

add_pfs_statement(StatementId_Atom, PFTraceStatement):-
    assert(get_pfs_statement(StatementId_Atom, PFTraceStatement)),
    !.

add_pfs_successor_statement(SuccessorStatementId_Atom,
                            PFTraceSuccessorStatement,
                            ParentStatementId_Atom):-
    assert(get_pfs_successor_statement(SuccessorStatementId_Atom,
                                       PFTraceSuccessorStatement,
                                       ParentStatementId_Atom)),
    !.

add_pfs_pf(PFId_Atom,
           Order_Int, 
           Number_Int,
           ParentSuccessorStatementId_Atom):-
    assert(get_pfs_pf(PFId_Atom,
                      Order_Int, 
                      Number_Int, 
                      ParentSuccessorStatementId_Atom)),
    !.

add_pfs_traversal_condition(Number_Int, TravCond_Term, ParentPFId_Atom):-
    assert(get_pfs_traversal_condition(Number_Int, TravCond_Term, ParentPFId_Atom)),
    !.

add_pfs_action(Action_Term, ParentPFId_Atom):-
    assert(get_pfs_action(Action_Term, ParentPFId_Atom)),
    !.
%===============================================================================


%===============================================================================
% save_dataprf.
%===============================================================================

save_dataprf:-
    must_get_datafiles_debug(datapfs, DebugFile_Atom),
    write_terms_to_file(DebugFile_Atom,
                        [datapfs:get_pfs_statement/2,
                         datapfs:get_pfs_successor_statement/3,
                         datapfs:get_pfs_pf/4,
                         datapfs:get_pfs_traversal_condition/3,
                         datapfs:get_pfs_action/2]),
    !.
%===============================================================================


%###############################################################################
% END-OF-FILE
