%  $Id: dataformats.pro 12106 2009-01-13 10:11:30Z Bill Ellis $
%-------------------------------------------------------------------------------
%  (C) Praxis High Integrity Systems Limited
%-------------------------------------------------------------------------------
% 
%  The SPARK toolset is free software; you can redistribute it and/or modify it
%  under terms of the GNU General Public License as published by the Free
%  Software Foundation; either version 3, or (at your option) any later
%  version. The SPARK toolset is distributed in the hope that it will be
%  useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
%  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
%  Public License for more details. You should have received a copy of the GNU
%  General Public License distributed with the SPARK toolset; see file
%  COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
%  the license.
% 
%===============================================================================


%###############################################################################
% PURPOSE
%-------------------------------------------------------------------------------
% This module offers no system functionality. It provides a location for
% modules to store their type and data descriptions. By providing a uniform
% interface, rather than embedding this information into comments, the
% expectation is that it will be more consistent, better maintained and
% easier to read.
%###############################################################################

:- module(dataformats, [get_state/2,
                        add_state/2,
                        get_type/2,
                        add_type/2]).


%###############################################################################
% DEPENDENCIES
%###############################################################################


%###############################################################################
% TYPES
%###############################################################################


%###############################################################################
% DATA
%###############################################################################

% As this module manages types and data, it is unable to initially manage
% its own types and data until the whole module has been parsed. For this
% reason the types and data declarations are contained in a predicated and
% dynamically invoked at the end of the module.
declare_data_formats:-
    add_state(get_state,
              get_state('Data_Atom', 'DataAttributes_Any')),

    add_state(get_type,
              get_type('Type_Atom', 'TypeAttributes_AnyList')).

:- dynamic(get_state/2).
:- dynamic(get_type/2).


%###############################################################################
% PREDICATES
%###############################################################################


%===============================================================================
% Add.
%===============================================================================

add_state(Data_Atom, DataAttributes_Any):-
    assert(get_state(Data_Atom, DataAttributes_Any)),
    !.

add_type(Type_Atom, TypeAttributes_AnyList):-
    assert(get_type(Type_Atom, TypeAttributes_AnyList)),
    !.
%===============================================================================


% Delayed setting of types and data for this module.
:- declare_data_formats.

%###############################################################################
% END-OF-FILE
