-- $Id: xmlsummary.ads 12255 2009-01-22 09:28:46Z Robin Messer $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


---------------------------------------------------------------------------------
-- Package for generating an XML version of the summary file.                  --
---------------------------------------------------------------------------------
with EStrings,
     SPARK_XML,
     SPARK_IO;
--# inherit CommandLine,
--#         ELStrings,
--#         EStrings,
--#         OSFiling,
--#         PathFormatter,
--#         SPARK_IO,
--#         SPARK_XML;

package XMLSummary
--# own State;
is

   subtype XMLString is SPARK_XML.XMLString;
   subtype XMLLongString is SPARK_XML.XMLLongString;

   type SummarySection is (SSTotals,
                           SSPercentages,
                           SSAssert_Post,
                           SSCheck,
                           SSInheritance,
                           SSPrecondition,
                           SSRefinement,
                           SSRuntime,
                           SSUndetermined);

   type ItemType is (ITExaminer,
                     ITSimplifier,
                     ITSimplifierUserRule,
                     ITChecker,
                     ITReview,
                     ITFalse,
                     ITContra,
                     ITUser,
                     ITUndischarged,
                     ITUndetermined);

   type VCStatus is (VCG,
                     SIV,
                     PLG,
                     REV,
                     WRONG,  -- can't redeclare False!!
                     CONTRA,
                     USER,
                     TODO);

   type FileType is (VCGFile,
                     SIVFile,
                     PLGFile,
                     REVFile);

   function XStr (Str : in String) return XMLString;

   procedure Init;
   --# global out State;
   --# derives State from ;


   -- Producers for simple container tags.
   -- These have no attributes of their own and only contain other tags.

   procedure StartPogs (ReportName  : in XMLString;
                        PogsVersion : in XMLString;
                        Licensee    : in XMLString;
                        IgnoreDates : in Boolean;
                        Report      : in SPARK_IO.File_Type);
   --# global in out SPARK_IO.File_Sys;
   --#        in out State;
   --# derives SPARK_IO.File_Sys from *,
   --#                                IgnoreDates,
   --#                                Licensee,
   --#                                PogsVersion,
   --#                                Report,
   --#                                ReportName,
   --#                                State &
   --#         State             from *,
   --#                                IgnoreDates,
   --#                                Licensee,
   --#                                PogsVersion,
   --#                                ReportName;



   procedure EndPogs (Report  : in SPARK_IO.File_Type);
   --# global in out SPARK_IO.File_Sys;
   --#        in out State;
   --# derives SPARK_IO.File_Sys from *,
   --#                                Report,
   --#                                State &
   --#         State             from *;

   procedure StartTypes (Report : in SPARK_IO.File_Type);
   --# global in out SPARK_IO.File_Sys;
   --#        in out State;
   --# derives SPARK_IO.File_Sys from *,
   --#                                Report,
   --#                                State &
   --#         State             from *;

   procedure EndTypes (Report : in SPARK_IO.File_Type);
   --# global in out SPARK_IO.File_Sys;
   --#        in out State;
   --# derives SPARK_IO.File_Sys from *,
   --#                                Report,
   --#                                State &
   --#         State             from *;


   procedure StartResults (Report  : in SPARK_IO.File_Type);
   --# global in out SPARK_IO.File_Sys;
   --#        in out State;
   --# derives SPARK_IO.File_Sys from *,
   --#                                Report,
   --#                                State &
   --#         State             from *;

   procedure EndResults (Report  : in SPARK_IO.File_Type);
   --# global in out SPARK_IO.File_Sys;
   --#        in out State;
   --# derives SPARK_IO.File_Sys from *,
   --#                                Report,
   --#                                State &
   --#         State             from *;

   procedure StartSummary (Report  : in SPARK_IO.File_Type);
   --# global in out SPARK_IO.File_Sys;
   --#        in out State;
   --# derives SPARK_IO.File_Sys from *,
   --#                                Report,
   --#                                State &
   --#         State             from *;

   procedure EndSummary (Report  : in SPARK_IO.File_Type);
   --# global in out SPARK_IO.File_Sys;
   --#        in out State;
   --# derives SPARK_IO.File_Sys from *,
   --#                                Report,
   --#                                State &
   --#         State             from *;


   procedure StartSubprogramSummary (TotalSubprogs : in Natural;
                                     Report : in SPARK_IO.File_Type);
   --# global in out SPARK_IO.File_Sys;
   --#        in out State;
   --# derives SPARK_IO.File_Sys from *,
   --#                                Report,
   --#                                State,
   --#                                TotalSubprogs &
   --#         State             from *,
   --#                                TotalSubprogs;

   procedure EndSubprogramSummary (Report : in SPARK_IO.File_Type);
   --# global in out SPARK_IO.File_Sys;
   --#        in out State;
   --# derives SPARK_IO.File_Sys from *,
   --#                                Report,
   --#                                State &
   --#         State             from *;

   procedure StartSubprogramsInErrorSummary (TotalSubprogsInError : in Natural;
                                             Report : in SPARK_IO.File_Type);
   --# global in out SPARK_IO.File_Sys;
   --#        in out State;
   --# derives SPARK_IO.File_Sys from *,
   --#                                Report,
   --#                                State,
   --#                                TotalSubprogsInError &
   --#         State             from *,
   --#                                TotalSubprogsInError;

   procedure EndSubprogramsInErrorSummary (Report : in SPARK_IO.File_Type);
   --# global in out SPARK_IO.File_Sys;
   --#        in out State;
   --# derives SPARK_IO.File_Sys from *,
   --#                                Report,
   --#                                State &
   --#         State             from *;

   procedure StartVCSummary (Report : in SPARK_IO.File_Type);
   --# global in out SPARK_IO.File_Sys;
   --#        in out State;
   --# derives SPARK_IO.File_Sys from *,
   --#                                Report,
   --#                                State &
   --#         State             from *;

   procedure EndVCSummary (Report : in SPARK_IO.File_Type);
   --# global in out SPARK_IO.File_Sys;
   --#        in out State;
   --# derives SPARK_IO.File_Sys from *,
   --#                                Report,
   --#                                State &
   --#         State             from *;


--     procedure StartVCs (Report  : in SPARK_IO.File_Type);
--     --# global in out SPARK_IO.File_Sys;
--     --#        in out State;
--     --# derives SPARK_IO.File_Sys from *,
--     --#                                State,
--     --#                                Report &
--     --#         State             from *;

--     procedure EndVCs (Report  : in SPARK_IO.File_Type);
--     --# global in out SPARK_IO.File_Sys;
--     --#        in out State;
--     --# derives SPARK_IO.File_Sys from *,
--     --#                                State,
--     --#                                Report &
--     --#         State             from *;



   ---------------------------------
   -- Container tags with attributes
   ---------------------------------


   -- For optional attributes, if the EmptyString is supplied then the attribute
   -- will not be added to the tag.

   procedure StartFile (Name       : in XMLLongString;
                        Proc       : in XMLString;
                        Generated  : in XMLString;
                        Simplified : in XMLString; -- Optional
                        Checked    : in XMLString; -- Optional
                        Report     : in SPARK_IO.File_Type);
   --# global in     CommandLine.Data;
   --#        in out SPARK_IO.File_Sys;
   --#        in out State;
   --# derives SPARK_IO.File_Sys from *,
   --#                                Checked,
   --#                                CommandLine.Data,
   --#                                Generated,
   --#                                Name,
   --#                                Proc,
   --#                                Report,
   --#                                Simplified,
   --#                                State &
   --#         State             from *,
   --#                                Checked,
   --#                                CommandLine.Data,
   --#                                Generated,
   --#                                Name,
   --#                                Proc,
   --#                                Simplified;

   procedure EndFile (Report  : in SPARK_IO.File_Type);
   --# global in out SPARK_IO.File_Sys;
   --#        in out State;
   --# derives SPARK_IO.File_Sys from *,
   --#                                Report,
   --#                                State &
   --#         State             from *;


   procedure FileError (Message : in EStrings.T;
                        FType   : in FileType;
                        Report  : in SPARK_IO.File_Type);
   --# global in out SPARK_IO.File_Sys;
   --#        in out State;
   --# derives SPARK_IO.File_Sys from *,
   --#                                FType,
   --#                                Message,
   --#                                Report,
   --#                                State &
   --#         State             from *,
   --#                                FType;



   procedure VC (VCNumber    : in XMLString;
                 FromPoint   : in XMLString;
                 ToPointType : in XMLString;
                 ToPoint     : in XMLString;
                 Status      : in VCStatus;
                 Report      : in SPARK_IO.File_Type);
   --# global in out SPARK_IO.File_Sys;
   --#        in out State;
   --# derives SPARK_IO.File_Sys from *,
   --#                                FromPoint,
   --#                                Report,
   --#                                State,
   --#                                Status,
   --#                                ToPoint,
   --#                                ToPointType,
   --#                                VCNumber &
   --#         State             from *,
   --#                                FromPoint,
   --#                                Status,
   --#                                ToPoint,
   --#                                ToPointType,
   --#                                VCNumber;


   procedure StartSummarySection (Section : in SummarySection;
                                  Total   : in Integer;
                                  Report  : in SPARK_IO.File_Type);
   --# global in out SPARK_IO.File_Sys;
   --#        in out State;
   --# derives SPARK_IO.File_Sys from *,
   --#                                Report,
   --#                                Section,
   --#                                State,
   --#                                Total &
   --#         State             from *,
   --#                                Section,
   --#                                Total;

   -- Summary sections cannot enclose each other, so calls to this
   -- procedure will just close the last opened section.
   procedure EndSummarySection (Report  : in SPARK_IO.File_Type);
   --# global in out SPARK_IO.File_Sys;
   --#        in out State;
   --# derives SPARK_IO.File_Sys from *,
   --#                                Report,
   --#                                State &
   --#         State             from *;



   -- Simple non-container tags.
   -- These either have just attributes or values

   procedure Directory (DirectoryName : in XMLLongString;
                        Report        : in SPARK_IO.File_Type);
   --# global in out SPARK_IO.File_Sys;
   --#        in out State;
   --# derives SPARK_IO.File_Sys from *,
   --#                                DirectoryName,
   --#                                Report,
   --#                                State &
   --#         State             from *;


   procedure Produced (ProducedDate : in XMLString;
                       Report       : in SPARK_IO.File_Type);
   --# global in out SPARK_IO.File_Sys;
   --#        in out State;
   --# derives SPARK_IO.File_Sys from *,
   --#                                ProducedDate,
   --#                                Report,
   --#                                State &
   --#         State             from *;

   procedure SummaryItemStr (Item   : in ItemType;
                             Value  : in EStrings.T;
                             Report : in SPARK_IO.File_Type);
   --# global in out SPARK_IO.File_Sys;
   --#        in out State;
   --# derives SPARK_IO.File_Sys from *,
   --#                                Item,
   --#                                Report,
   --#                                State,
   --#                                Value &
   --#         State             from *,
   --#                                Item;

   procedure SummaryItemInt (Item   : in ItemType;
                             Value  : in Integer;
                             Report : in SPARK_IO.File_Type);
   --# global in out SPARK_IO.File_Sys;
   --#        in out State;
   --# derives SPARK_IO.File_Sys from *,
   --#                                Item,
   --#                                Report,
   --#                                State,
   --#                                Value &
   --#         State             from *,
   --#                                Item;

   procedure AnalysisType (Typ    : in XMLString;
                           Report : in SPARK_IO.File_Type);
   --# global in out SPARK_IO.File_Sys;
   --#        in out State;
   --# derives SPARK_IO.File_Sys from *,
   --#                                Report,
   --#                                State,
   --#                                Typ &
   --#         State             from *;


end XMLSummary;
