-- $Id: vcs.ads 11367 2008-10-07 15:47:17Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


--------------------------------------------------------------------------------
--Synopsis:                                                                   --
--                                                                            --
--Package to perform processing of VC files                                   --
--                                                                            --
--------------------------------------------------------------------------------
with ELStrings,
     SPARK_IO;

use type SPARK_IO.File_Status;

--# inherit Ada.Characters.Handling,
--#         Banner,
--#         CommandLine,
--#         ELStrings,
--#         EStrings,
--#         FatalErrors,
--#         Heap,
--#         OSFiling,
--#         PathFormatter,
--#         SLG_Parser,
--#         Spark_Calendar,
--#         SPARK_IO,
--#         Total,
--#         VCDetails,
--#         VCHeap,
--#         XMLSummary;
package VCS
is

   -- given the filename, without extension, process vcg, siv, plg and prv files
   -- if/as appropriate
   procedure Analyse (ReportFile        : in     SPARK_IO.File_Type;
                      FileName          : in     ELStrings.T;
                      AnalyseProofLog   : in     Boolean;
                      TempFile          : in     SPARK_IO.File_Type;
                      TempFalseFile     : in     SPARK_IO.File_Type;
                      TempContraFile    : in     SPARK_IO.File_Type;
                      TempUserFile      : in     SPARK_IO.File_Type;
                      TempRluErrorFile  : in out SPARK_IO.File_Type;
                      TempRluUsedFile   : in out SPARK_IO.File_Type;
                      TempPRVerrFile    : in     SPARK_IO.File_Type;
                      TempWarnErrorFile : in     SPARK_IO.File_Type);
   --# global in     CommandLine.Data;
   --#        in     OSFiling.FileStructure;
   --#        in out FatalErrors.State;
   --#        in out SPARK_IO.File_sys;
   --#        in out Total.State;
   --#        in out VCHeap.I_State;
   --#        in out VCHeap.State;
   --#        in out XMLSummary.State;
   --# derives FatalErrors.State from *,
   --#                                AnalyseProofLog,
   --#                                CommandLine.Data,
   --#                                FileName,
   --#                                OSFiling.FileStructure,
   --#                                ReportFile,
   --#                                SPARK_IO.File_sys,
   --#                                TempRluErrorFile,
   --#                                TempRluUsedFile,
   --#                                VCHeap.I_State,
   --#                                VCHeap.State &
   --#         SPARK_IO.File_sys from *,
   --#                                AnalyseProofLog,
   --#                                CommandLine.Data,
   --#                                FileName,
   --#                                OSFiling.FileStructure,
   --#                                ReportFile,
   --#                                TempContraFile,
   --#                                TempFalseFile,
   --#                                TempFile,
   --#                                TempPRVerrFile,
   --#                                TempRluErrorFile,
   --#                                TempRluUsedFile,
   --#                                TempUserFile,
   --#                                TempWarnErrorFile,
   --#                                VCHeap.I_State,
   --#                                VCHeap.State,
   --#                                XMLSummary.State &
   --#         TempRluErrorFile,
   --#         TempRluUsedFile   from *,
   --#                                FileName,
   --#                                OSFiling.FileStructure,
   --#                                SPARK_IO.File_sys &
   --#         Total.State,
   --#         VCHeap.State,
   --#         XMLSummary.State  from *,
   --#                                AnalyseProofLog,
   --#                                CommandLine.Data,
   --#                                FileName,
   --#                                OSFiling.FileStructure,
   --#                                ReportFile,
   --#                                SPARK_IO.File_sys,
   --#                                VCHeap.I_State,
   --#                                VCHeap.State &
   --#         VCHeap.I_State    from *,
   --#                                CommandLine.Data,
   --#                                FileName,
   --#                                OSFiling.FileStructure,
   --#                                ReportFile,
   --#                                SPARK_IO.File_sys;

end VCS;
