-- $Id: vcs-writevcinfo.adb 11367 2008-10-07 15:47:17Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


--------------------------------------------------------------------------------
--Synopsis:                                                                   --
--                                                                            --
--WriteVCInfo procedure for VCS package.                                      --
--                                                                            --
--------------------------------------------------------------------------------
separate (VCS)
procedure WriteVCInfo (ReportFile              : in     SPARK_IO.File_Type;
                       VCInfo                  : in     VCInfoType;
                       AnythingPrintedThisTime :    out Boolean)
is
   ------------------------------------------------------------------------
   procedure PrintLineNumber (ReportFile  : in SPARK_IO.File_Type;
                              LineNumber  : in VCLineType;
                              StartOfLine : in Boolean)
   --# global in out SPARK_IO.File_sys;
   --# derives SPARK_IO.File_sys from *,
   --#                                LineNumber,
   --#                                ReportFile,
   --#                                StartOfLine;
   is
      Width : Natural;
   begin
      if LineNumber = VCLineStart then
         SPARK_IO.Put_String (ReportFile, "start", 0);
      elsif LineNumber = VCLineEnd then
         SPARK_IO.Put_String (ReportFile, "finish", 0);
      else
         if StartOfLine then
            Width := 5;
         else
            Width := 0;
         end if;
         SPARK_IO.Put_Integer (ReportFile, LineNumber, Width, 10);
      end if;
   end PrintLineNumber;
   ------------------------------------------------------------------------
begin -- WriteVCInfo
   if VCInfo.NumberOfVCs > 0 then
      AnythingPrintedThisTime := True;

      if VCInfo.FileType = SimplifiedVCFileType and
         not VCInfo.AnyVCsPrinted then

         SPARK_IO.New_Line (ReportFile, 1);
         SPARK_IO.Put_Line (ReportFile, "Undischarged VCs remain for lines:", 0);
      end if;

      if not VCInfo.ThisStartLinePrinted or else
         SPARK_IO.Col (ReportFile) > ReportWrapColumn then
         SPARK_IO.New_Line (ReportFile, 1);
         -- write new start line
         PrintLineNumber (ReportFile, VCInfo.StartLine, True);
         SPARK_IO.Put_String (ReportFile, " to: ", 0);
      else
         SPARK_IO.Put_String (ReportFile, ", ", 0);
      end if;

      -- write last line of range
      PrintLineNumber (ReportFile, VCInfo.EndLine, False);
      -- print VC count
      SPARK_IO.Put_Char (ReportFile, '(');
      SPARK_IO.Put_Integer (ReportFile, VCInfo.NumberOfVCs, 0, 10);
      SPARK_IO.Put_Char (ReportFile, ')');
   else
      AnythingPrintedThisTime := False;
   end if;
end WriteVCInfo;
