-- $Id: total.ads 12146 2009-01-14 13:14:58Z Rod Chapman $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


--------------------------------------------------------------------------------
--Synopsis:                                                                   --
--                                                                            --
--Package providing data structure to store running totals, and a procedure   --
--to print them.                                                              --
--                                                                            --
--------------------------------------------------------------------------------
with SPARK_IO;
--# inherit Banner,
--#         CommandLine,
--#         ELStrings,
--#         EStrings,
--#         FatalErrors,
--#         Heap,
--#         SPARK_IO,
--#         VCDetails,
--#         VCHeap,
--#         XMLSummary;
package Total
   --# own State;
   --# initializes State;
is

   procedure UpdateTotals;
   --# global in     VCHeap.State;
   --#        in out State;
   --# derives State from *,
   --#                    VCHeap.State;


   procedure Output (ReportFile        : in SPARK_IO.File_Type;
                     TempFile          : in out SPARK_IO.File_Type;
                     TempFalseFile     : in out SPARK_IO.File_Type;
                     TempContraFile    : in out SPARK_IO.File_Type;
                     TempUserFile      : in out SPARK_IO.File_Type;
                     TempRluErrorFile  : in out SPARK_IO.File_Type;
                     TempRluUsedFile   : in out SPARK_IO.File_Type;
                     TempPRVerrFile    : in out SPARK_IO.File_Type;
                     TempWarnErrorFile : in out SPARK_IO.File_Type);
   --# global in     CommandLine.Data;
   --#        in     State;
   --#        in out SPARK_IO.File_Sys;
   --# derives SPARK_IO.File_Sys from *,
   --#                                CommandLine.Data,
   --#                                ReportFile,
   --#                                State,
   --#                                TempContraFile,
   --#                                TempFalseFile,
   --#                                TempFile,
   --#                                TempPRVerrFile,
   --#                                TempRluErrorFile,
   --#                                TempRluUsedFile,
   --#                                TempUserFile,
   --#                                TempWarnErrorFile &
   --#         TempContraFile,
   --#         TempFalseFile,
   --#         TempFile,
   --#         TempPRVerrFile,
   --#         TempRluErrorFile,
   --#         TempRluUsedFile,
   --#         TempUserFile,
   --#         TempWarnErrorFile from *;

   procedure XMLOutput (ReportFile : in SPARK_IO.File_Type);
   --# global in     State;
   --#        in out SPARK_IO.File_Sys;
   --#        in out XMLSummary.State;
   --# derives SPARK_IO.File_Sys from *,
   --#                                ReportFile,
   --#                                State,
   --#                                XMLSummary.State &
   --#         XMLSummary.State  from *,
   --#                                State;

end Total;
