-- $Id: spark_calendar.ads 11367 2008-10-07 15:47:17Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


with Calendar;

package SPARK_Calendar
--# own Time_History; --(brief)
--# initializes Time_History;
is

   type Error_Code is (Valid, Time_Error);

   type Time is private;

   subtype Year_Number  is Integer range 1901 .. 2099;
   subtype Month_Number is Integer range 1 .. 12;
   subtype Day_Number   is Integer range 1 .. 31;

   -- function Clock converted to procedure, and dummy history variable added for annotations.
   procedure Clock (Now    : out Time);
   --# global in out Time_History;
   --# derives Now,
   --#         Time_History from Time_History;

   -- Function converted to procedure to allow error handling
   procedure Year (Date   : in     Time;
                   Result :    out Year_Number;
                   Status :    out Error_Code);
   --# derives Result,
   --#         Status from Date;

   function Month   (Date : Time) return Month_Number;

   function Day     (Date : Time) return Day_Number;

   procedure Split
     (Date    : in     Time;
      Year_P  :    out Year_Number;
      Month_P :    out Month_Number;
      Day_P   :    out Day_Number;
      Status  :    out Error_Code);
   --# derives Day_p,
   --#         Month_p,
   --#         Status,
   --#         Year_p  from Date;

   -- Function converted to procedure to allow error handling
   procedure Time_Of
     (Year_P  : in     Year_Number;
      Month_P : in     Month_Number;
      Day_P   : in     Day_Number;
      Result  :    out Time;
      Status  :    out Error_Code);
   --# derives Result,
   --#         Status from Day_p,
   --#                     Month_p,
   --#                     Year_p;

   function LT (Left, Right : Time) return Boolean;
   function LE (Left, Right : Time) return Boolean;
   function GT (Left, Right : Time) return Boolean;
   function GE (Left, Right : Time) return Boolean;

private
   --# hide SPARK_Calendar;

   pragma Inline (Clock);

   pragma Inline (Year);
   pragma Inline (Month);
   pragma Inline (Day);

   pragma Inline (Split);
   pragma Inline (Time_Of);

   pragma Inline (LT);
   pragma Inline (LE);
   pragma Inline (GT);
   pragma Inline (GE);

   type Time is new Calendar.Time;

end SPARK_Calendar;
