-- $Id: pathformatter.adb 12243 2009-01-21 15:27:13Z Robin Messer $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


--------------------------------------------------------------------------------
--Synopsis:                                                                   --
--                                                                            --
--To provide a standardised file name format which is platform independent    --
--when the -plain option is chosen.                                           --
--                                                                            --
--------------------------------------------------------------------------------
with CommandLine;
package body PathFormatter
is
   function Format (RawFileName : ELStrings.T)
      return ELStrings.T
   is
      WorkingDir : ELStrings.T;
      Result     : ELStrings.T;
   begin
      if CommandLine.Data.PlainOutput then
         -- strip the working directory off the start of VCFileName
         WorkingDir := CommandLine.Data.StartDirectory;
         Result := ELStrings.Section (
            RawFileName,
            (WorkingDir.Length + 1),
            (RawFileName.Length - WorkingDir.Length));

         -- Convert back slash directory separators to forward slashes
         for I in ELStrings.Lengths range 1 .. Result.Length loop
            --# assert Result%.Length = Result.Length;
            if Result.Content (I) = '\' then
               Result.Content (I) := '/';
            end if;
         end loop;
      else
         Result := RawFileName;
      end if;
      return Result;
   end Format;
end PathFormatter;
