-- $Id: osfiling.ads 12315 2009-01-28 09:24:01Z Robin Messer $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


--------------------------------------------------------------------------------
--Synopsis:                                                                   --
--                                                                            --
--Platform dependent package supplying low level filing utilities. FindFiles  --
--is separate to prevent cyclic interpackage dependencies                     --
--                                                                            --
--------------------------------------------------------------------------------
with EStrings;
with ELStrings;

--# inherit ELStrings,
--#         EStrings,
--#         SPARK_IO;

package OSFiling
--# own FileStructure;
--# initializes FileStructure;
is
   -- Return the filename from the string given, without drive or directory
   -- designation.
   -- Not guaranteed to work correctly if soft links are in the path.
   function BaseFileName (Path : ELStrings.T) return ELStrings.T;

   -- Return the directory from the string given, without drive or full path
   -- designation. If a string such as "." or ".." is given then the actual
   -- directory name is returned.
   -- Not guaranteed to work correctly if soft links are in the path.
   function BaseDirName (Path : ELStrings.T) return ELStrings.T;

   function DefaultReportExtn return EStrings.T;

   -- this function combines the inputs to produce the path to the
   -- subdirectory
   function DownDirectory (Path         : ELStrings.T;
                           SubDirectory : ELStrings.T)
                          return ELStrings.T;

   -- this function combines the inputs to produce a full file name
   function FullFileName (Path     : ELStrings.T;
                          FileName : ELStrings.T)
                         return ELStrings.T;

   function GetWorkingDirectory return ELStrings.T;
   --# global in FileStructure;

   -- true iff the specified name is a directory
   function IsDirectory (Name : ELStrings.T)
                        return Boolean;
   --# global in FileStructure;

   -- true iff the specified name exists and is not a directory
   function IsFile (Name : ELStrings.T) return Boolean;
   --# global in FileStructure;

   -- return which name comes first in dictionary order
   -- with the quirk that on the VAX, the file [spark]pogs
   -- immediately preceeds the directory [spark.pogs]
   function Order (FirstName, SecondName : ELStrings.T)
                 return ELStrings.OrderTypes;

   -- remove the file extension: on the VAX this includes removing the
   -- file version number, but the reverse scan for a '.' must not go
   -- past the ']' because there are '.'s in dir specifications
   procedure RemoveFileExtension
     (FileName : in out ELStrings.T);
   --# derives FileName from *;

   -- return the file extension for a simplified VC file
   function SimplifiedVCFileExtension return EStrings.T;

   -- this function removes the last directory name from the supplied string
   function DirName (Path : ELStrings.T)
                     return ELStrings.T;

   -- return the file extension for a VC file
   function VCFileExtension return EStrings.T;

   -- return the file extension for a Proof Log file
   function ProofLogFileExtension return EStrings.T;

   -- return the file extension for a Review file
   function ReviewFileExtension return EStrings.T;

   -- return the file extension for a Simplifier Log file
   function SimplifierLogFileExtension return EStrings.T;

   -- return the platform specific directory separator
   function DirectorySeparator return Character;

end OSFiling;
