-- $Id: osdirectory.ads 11367 2008-10-07 15:47:17Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


--------------------------------------------------------------------------------
--Synopsis:                                                                   --
--                                                                            --
--SUN version of package to scan a directory.                                 --
--                                                                            --
--------------------------------------------------------------------------------
with Heap;

--# inherit ELStrings,
--#         EStrings,
--#         FatalErrors,
--#         FileDetails,
--#         FileHeap,
--#         Heap,
--#         OSFiling;
package OSDirectory
is
   ------------------------------------------------------------------------
   -- this procedure reads the named directory using the C calls
   -- opendir(), readdir() and closedir()
   -- for each entry, it calls OSFiling.IsDirectory and then enters it in the
   -- linked list
   ------------------------------------------------------------------------
   procedure Scan (ListIndex : in Heap.Atom);
   --# global in     OSFiling.FileStructure;
   --#        in out FatalErrors.State;
   --#        in out FileHeap.State;
   --# derives FatalErrors.State,
   --#         FileHeap.State    from *,
   --#                                ListIndex,
   --#                                OSFiling.FileStructure;
end OSDirectory;
