-- $Id: heap.ads 11367 2008-10-07 15:47:17Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


with HeapIndex;
--# inherit HeapIndex;
package Heap
--158 own var clauses removed
is

   ListLength : constant Integer := 80000;  --291, 293 (same as 1.2(c))
   type Atom is range 0 .. ListLength;
   --# assert Atom'Base is Integer;

   --158 new abstract data type
   type HeapRecord is private;

   --158 new procedure
   procedure Initialize (TheHeap : out HeapRecord);
   --# derives TheHeap from ;


   --158 Heap added as a parameter and removed from globals list below
   procedure CreateAtom (TheHeap : in out HeapRecord;
                         NewAtom :    out Atom;
                         Success :    out Boolean);
   --# derives NewAtom,
   --#         Success,
   --#         TheHeap from TheHeap;

   procedure DisposeOfAtom (TheHeap : in out HeapRecord;
                            OldAtom : in     Atom);
   --# derives TheHeap from *,
   --#                      OldAtom;


   function APointer (TheHeap : HeapRecord;
                      A       : Atom) return Atom;


   function BPointer (TheHeap : HeapRecord;
                      A       : Atom) return Atom;


   function AValue (TheHeap : HeapRecord;
                    A       : Atom) return HeapIndex.IndexType;


   function BValue (TheHeap : HeapRecord;
                    A       : Atom) return HeapIndex.IndexType;


   procedure UpdateAPointer (TheHeap : in out HeapRecord;
                             A       : in     Atom;
                             Pointer : in     Atom);
   --# derives TheHeap from *,
   --#                      A,
   --#                      Pointer;

   procedure UpdateBPointer (TheHeap : in out HeapRecord;
                             A       : in     Atom;
                             Pointer : in     Atom);
   --# derives TheHeap from *,
   --#                      A,
   --#                      Pointer;


   procedure UpdateAValue (TheHeap : in out HeapRecord;
                           A       : in     Atom;
                           Value   : in     HeapIndex.IndexType);
   --# derives TheHeap from *,
   --#                      A,
   --#                      Value;


   procedure UpdateBValue (TheHeap : in out HeapRecord;
                           A       : in     Atom;
                           Value   : in     HeapIndex.IndexType);
   --# derives TheHeap from *,
   --#                      A,
   --#                      Value;

   --159 new function used in RefList
   function IsNullPointer (A : Atom) return Boolean;


   --158
private
   type AtomDescriptor is
      record
         ValueA,   ValueB   : HeapIndex.IndexType;
         PointerA, PointerB : Atom;
      end record;
   pragma Pack (AtomDescriptor);
   type ArrayOfAtoms is array (Atom) of AtomDescriptor;

   type HeapRecord is record
      ListOfAtoms  : ArrayOfAtoms;
      HighMark,                           --160
      NextFreeAtom : Atom;
   end record;

end Heap;
