-- $Id: fatalerrors.ads 12146 2009-01-14 13:14:58Z Rod Chapman $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


--------------------------------------------------------------------------------
--Synopsis:                                                                   --
--                                                                            --
--Note that the Process procedure does not return to point of call. Instead   --
--it raises an exception which is trapped by the main program, which causes   --
--the program to stop politely.                                               --
--                                                                            --
--The use of the State variable makes it easy to see where fatal errors may   --
--occur                                                                       --
--------------------------------------------------------------------------------
with ELStrings;

--# inherit ELStrings,
--#         EStrings,
--#         CommandLine,
--#         SPARK_IO;
package FatalErrors
--# own State;
--# initializes State;
is
   type ErrorType is (CouldNotOpenInputFile,
                      CouldNotCreateReportFile,
                      DataStructureInconsistency,
                      VCDataStructureInconsistency,
                      ExpectedDirectoryMissing,
                      FileHeapFull,
                      VCHeapFull,
                      InvalidCommandLine,
                      ProblemReadingFile,
                      ProblemCreatingTempFile,
                      SubprogramTotalsInconsistent);

   -- note Process DOES NOT return
   procedure Process (Error   : in ErrorType;
                      Message : in ELStrings.T);
   --# global out State;
   --# derives State from Error, Message;
   --# post False; -- does not terminate normally

end FatalErrors;
