-- $Id: commandline.ads 12097 2009-01-12 17:01:08Z Robin Messer $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


--------------------------------------------------------------------------------
--Synopsis:                                                                   --
--                                                                            --
--To provide global state representing the command line options and a         --
--procedure to parse the system command line.                                 --
--                                                                            --
--------------------------------------------------------------------------------

with OSCommandLine;
with EStrings;

--# inherit Ada.Characters.Latin_1,
--#         ELStrings,
--#         EStrings,
--#         OSCommandLine,
--#         OSFiling;

package CommandLine
--# own Data;
is

   -- Data structure to hold result of processing arguments
   Data : OSCommandLine.DataType;

   -- Read in and process the command line arguments
   procedure Read;
   --# global in     OSCommandLine.State;
   --#        in     OSFiling.FileStructure;
   --#           out Data;
   --# derives Data from OSCommandLine.State,
   --#                   OSFiling.FileStructure;

   -- Returns a "usage" string for reporting to user when command line
   -- is invalid.
   function UsageString return EStrings.T;

end CommandLine;
