-- $Id: commandline.adb 12312 2009-01-27 14:24:42Z Robin Messer $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


--------------------------------------------------------------------------------
--Synopsis:                                                                   --
--                                                                            --
--To provide global state representing the command line options and a         --
--procedure to parse the system command line.                                 --
--                                                                            --
--------------------------------------------------------------------------------
with ELStrings,
     OSFiling;

package body CommandLine
is

   function UsageString return EStrings.T
   is
      Result : EStrings.T;
   begin
      EStrings.CopyString (Result, "pogs [-d=input_directory] [-i] [-o=output_file] [-p] [-s | -x] [-v]");
      return Result;
   end UsageString;

   procedure Read
   is

      ReportFileName   : ELStrings.T;
      TempString       : ELStrings.T;

   begin

      -- Process the command line arguments and store the result in Data
      OSCommandLine.Read (Data);

      -- What should the report filename be?
      -- -d specified?  -o specified?  Output filename
      -- =============  =============  ===============
      --    No               No        CWD.sum
      --    No               Yes       As specified (relative to CWD or absolute)
      --    Yes              No        Located in, and named after, specified output dir
      --    Yes              Yes       Located in specified output dir unless absolute path given

      if ELStrings.IsEmpty (Data.ReportFile) then

         ReportFileName := OSFiling.BaseDirName (Data.StartDirectory);
         ELStrings.AppendExaminerString (ReportFileName,
                                         OSFiling.DefaultReportExtn);
         Data.ReportFile := OSFiling.FullFileName (Data.StartDirectory,
                                                   ReportFileName);
      else

         OSCommandLine.Normalize_Pathname
            (InputFile  => Data.ReportFile,
             InputDir   => Data.StartDirectory,
             ResultPath => TempString);
         Data.ReportFile := TempString;

      end if;

   end Read;

end CommandLine;
