-- $Id: xmlreport.ads 11674 2008-11-12 12:20:09Z rod chapman $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


with EStrings,
     ELStrings,
     SPARK_XML,
     SPARK_IO;
--# inherit CommandLineData,
--#         ELStrings,
--#         EStrings,
--#         FileSystem,
--#         SPARK_IO,
--#         SPARK_XML,
--#         SystemErrors;

package XMLReport
--# own State;
is

   type Sections is (SReport,
                     SPrologue,
                     SCommandline,
                     SCompilerData,
                     SCyclicRequirements,
                     SIndexes,
                     STargetConfig,
                     SMessages,
                     SMetaFiles,
                     SUnitsNotFound,
                     SWarningsConfig,
                     SResults,
                     SListing,
                     SUnitsInFile,
                     SJustifications,
                     SFullJustifications
                    );

   MaxMetaFileDepth : constant Integer := 50;

   subtype MetaFileId is SPARK_XML.TagDepth;

   subtype VString is EStrings.T;
   subtype XMLString is EStrings.T;

   subtype VLongString is ELStrings.T;
   subtype XMLLongString is ELStrings.T;

   function XStr (Str : in String) return EStrings.T;
   function FilterString (Str : in XMLString) return XMLString;

   function FilterLongString (Str : in XMLLongString) return XMLLongString;


   procedure Init;
   --# global out State;
   --# derives State from ;




   -- Producers for simple container tags.
   -- These have no attributes of their own and only contain other tags.
   -- The only exception is the Listing tag, which contains large amounts of text,
   -- and is also included.

   procedure StartSection (Section : in Sections;
                           Report  : in SPARK_IO.File_Type);
   --# global in out SPARK_IO.File_Sys;
   --#        in out State;
   --# derives SPARK_IO.File_Sys from *,
   --#                                Report,
   --#                                Section,
   --#                                State &
   --#         State             from *,
   --#                                Section;


   procedure EndSection (Section : in Sections;
                         Report  : in SPARK_IO.File_Type);
   --# global in out SPARK_IO.File_Sys;
   --#        in out State;
   --# derives SPARK_IO.File_Sys from *,
   --#                                Report,
   --#                                Section,
   --#                                State &
   --#         State             from *,
   --#                                Section;





   -- Simple tags, ones whose opening and closing tags are generated
   -- at the same time.  E.g. <filename>file.txt</filename>

   procedure Filename (File   : in VString;
                       Report : in SPARK_IO.File_Type);
   --# global in     CommandLineData.Content;
   --#        in out SPARK_IO.File_Sys;
   --#        in out State;
   --# derives SPARK_IO.File_Sys from *,
   --#                                CommandLineData.Content,
   --#                                File,
   --#                                Report,
   --#                                State &
   --#         State             from *,
   --#                                CommandLineData.Content;



   procedure Index (Idx    : in VString;
                    Report : in SPARK_IO.File_Type);
   --# global in     CommandLineData.Content;
   --#        in out SPARK_IO.File_Sys;
   --#        in out State;
   --# derives SPARK_IO.File_Sys from *,
   --#                                CommandLineData.Content,
   --#                                Idx,
   --#                                Report,
   --#                                State &
   --#         State             from *,
   --#                                CommandLineData.Content;


   procedure CompilerItem (Item   : in VString;
                           Val    : in VString;
                           Report : in SPARK_IO.File_Type);
   --# global in out SPARK_IO.File_Sys;
   --#        in out State;
   --# derives SPARK_IO.File_Sys from *,
   --#                                Item,
   --#                                Report,
   --#                                State,
   --#                                Val &
   --#         State             from *,
   --#                                Item;


   procedure LongCompilerItem (Item   : in VString;
                               Val    : in VLongString;
                               Report : in SPARK_IO.File_Type);
   --# global in out SPARK_IO.File_Sys;
   --#        in out State;
   --# derives SPARK_IO.File_Sys from *,
   --#                                Item,
   --#                                Report,
   --#                                State,
   --#                                Val &
   --#         State             from *,
   --#                                Item;


   procedure Suppressed (Item   : in VString;
                         Report : in SPARK_IO.File_Type);
   --# global in out SPARK_IO.File_Sys;
   --#        in out State;
   --# derives SPARK_IO.File_Sys from *,
   --#                                Item,
   --#                                Report,
   --#                                State &
   --#         State             from *;


   procedure SuppressedPragma (Item   : in VString;
                               Report : in SPARK_IO.File_Type);
   --# global in out SPARK_IO.File_Sys;
   --#        in out State;
   --# derives SPARK_IO.File_Sys from *,
   --#                                Item,
   --#                                Report,
   --#                                State &
   --#         State             from *;


   procedure Option (Opt    : in VString;
                     Report : in SPARK_IO.File_Type);
   --# global in out SPARK_IO.File_Sys;
   --#        in out State;
   --# derives SPARK_IO.File_Sys from *,
   --#                                Opt,
   --#                                Report,
   --#                                State &
   --#         State             from *;


   procedure Unit (Name   : in VString;
                   Typ    : in VString;
                   Report : in SPARK_IO.File_Type);
   --# global in out SPARK_IO.File_Sys;
   --#        in out State;
   --# derives SPARK_IO.File_Sys from *,
   --#                                Name,
   --#                                Report,
   --#                                State,
   --#                                Typ &
   --#         State             from *,
   --#                                Name,
   --#                                Typ;


   -- Ada Units in a file.
   procedure AdaUnit (Name       : in VString;
                      Typ        : in VString;
                      UnitStatus : in VString;
                      Report     : in SPARK_IO.File_Type);
   --# global in out SPARK_IO.File_Sys;
   --#        in out State;
   --# derives SPARK_IO.File_Sys from *,
   --#                                Name,
   --#                                Report,
   --#                                State,
   --#                                Typ,
   --#                                UnitStatus &
   --#         State             from *,
   --#                                Name,
   --#                                Typ,
   --#                                UnitStatus;



   -- Message construction.

   procedure StartMessage (Class  : in VString;
                           Code   : in Integer;
                           Line   : in Integer;
                           Offset : in Integer;
                           Report : in SPARK_IO.File_Type);
   --# global in out SPARK_IO.File_Sys;
   --#        in out State;
   --# derives SPARK_IO.File_Sys from *,
   --#                                Class,
   --#                                Code,
   --#                                Line,
   --#                                Offset,
   --#                                Report,
   --#                                State &
   --#         State             from *,
   --#                                Class,
   --#                                Code,
   --#                                Line,
   --#                                Offset;



   procedure Symbol (Sym    : in VString;
                     SymNum : in Integer;
                     Report : in SPARK_IO.File_Type);
   --# global in out SPARK_IO.File_Sys;
   --#        in out State;
   --# derives SPARK_IO.File_Sys from *,
   --#                                Report,
   --#                                State,
   --#                                Sym,
   --#                                SymNum &
   --#         State             from *,
   --#                                SymNum;



   procedure EndMessage (Report : in SPARK_IO.File_Type);
   --# global in out SPARK_IO.File_Sys;
   --#        in out State;
   --# derives SPARK_IO.File_Sys from *,
   --#                                Report,
   --#                                State &
   --#         State             from *;


   -- Metafile contruction

   procedure StartMetaFile (Name   : in     VString;
                            Report : in     SPARK_IO.File_Type);
   --# global in out SPARK_IO.File_Sys;
   --#        in out State;
   --# derives SPARK_IO.File_Sys from *,
   --#                                Name,
   --#                                Report,
   --#                                State &
   --#         State             from *,
   --#                                Name;



   procedure EndMetaFile (Report : in SPARK_IO.File_Type);
   --# global in out SPARK_IO.File_Sys;
   --#        in out State;
   --# derives SPARK_IO.File_Sys from *,
   --#                                Report,
   --#                                State &
   --#         State             from *;


   -- Results Section contents

   procedure StartFile (FName    : in VString;
                        Report   : in SPARK_IO.File_Type);
   --# global in     CommandLineData.Content;
   --#        in out SPARK_IO.File_Sys;
   --#        in out State;
   --# derives SPARK_IO.File_Sys from *,
   --#                                CommandLineData.Content,
   --#                                FName,
   --#                                Report,
   --#                                State &
   --#         State             from *,
   --#                                CommandLineData.Content,
   --#                                FName;


   procedure EndFile (Report : in SPARK_IO.File_Type);
   --# global in out SPARK_IO.File_Sys;
   --#        in out State;
   --# derives SPARK_IO.File_Sys from *,
   --#                                Report,
   --#                                State &
   --#         State             from *;


   procedure BriefJustifications (Matched   : in Natural;
                                  Unmatched : in Natural;
                                  Report    : in SPARK_IO.File_Type);
   --# global in out SPARK_IO.File_Sys;
   --#        in out State;
   --# derives SPARK_IO.File_Sys from *,
   --#                                Matched,
   --#                                Report,
   --#                                State,
   --#                                Unmatched &
   --#         State             from *,
   --#                                Matched,
   --#                                Unmatched;

   procedure StartFullJustification (Class     : in VString;
                                     Code      : in Integer;
                                     LineFrom  : in Integer;
                                     LineTo    : in VString;
                                     MatchNo   : in Integer;
                                     MatchLine : in Integer;
                                     Report    : in SPARK_IO.File_Type);
   --# global in out SPARK_IO.File_Sys;
   --#        in out State;
   --# derives SPARK_IO.File_Sys from *,
   --#                                Class,
   --#                                Code,
   --#                                LineFrom,
   --#                                LineTo,
   --#                                MatchLine,
   --#                                MatchNo,
   --#                                Report,
   --#                                State &
   --#         State             from *,
   --#                                Class,
   --#                                Code,
   --#                                LineFrom,
   --#                                LineTo,
   --#                                MatchLine,
   --#                                MatchNo;

   procedure EndFullJustification (Report : in SPARK_IO.File_Type);
   --# global in out SPARK_IO.File_Sys;
   --#        in out State;
   --# derives SPARK_IO.File_Sys from *,
   --#                                Report,
   --#                                State &
   --#         State             from *;

end XMLReport;
