-- $Id: vcg.ads 12814 2009-03-27 16:12:27Z Rod Chapman $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================

--------------------------------------------------------------------------------
--  VCG
--
--  Purpose:
--
--  The main entry point of the VC-Generator.  Takes the Syntax-Tree, Dictionary,
--  LexTokenManager table and Flow Analyser Heap that have been previously
--  populated by the Sem and FlowAnalyser phases, and produces Verfication
--  Conditions or Path Functions for the given subprogram.
--
--  In many of the VCG Components, there are references to "JFB section x.y"
--  These are referring to
--   Jean Francois Bergeretti
--   "An Algebraic Approach to Program Analysis: Foundations of a Practical
--     Analysis System"
--   PhD Thesis
--   University of Southampton Department of Electronics, 1979
--
--  This document effectively serves as a mathematical specification of the
--  VC Generator.
--
--  For a copy of this document, please contact either the SPARK team at Praxis
--  (sparkinfo@praxis-his.com), or contract the University of Southampton.
--
--  Clients:
--
--  Sem.CompUnit
--
--  Use:
--
--  See Sem.Compunit
--
--  Extension:
--
--  None planned.
--------------------------------------------------------------------------------

with STree,
  LexTokenManager,
  Dictionary,
  CommandLineData,
  Heap;

use type Dictionary.Symbol;
use type Dictionary.Scopes;
use type Dictionary.RulePolicies;
use type CommandLineData.RedTypes;
use type CommandLineData.RuleGenerationPolicies;

--# inherit Cells,
--#         CLists,
--#         CommandLineData,
--#         CStacks,
--#         DAG,
--#         Debug,
--#         Declarations,
--#         Dictionary,
--#         ErrorHandler,
--#         EStrings,
--#         ExaminerConstants,
--#         FileSystem,
--#         File_Utils,
--#         Graph,
--#         Heap,
--#         Labels,
--#         LexTokenLists,
--#         LexTokenManager,
--#         Maths,
--#         Pairs,
--#         Pile,
--#         ScreenEcho,
--#         SeqAlgebra,
--#         SPARK_IO,
--#         SPSymbols,
--#         Statistics,
--#         StmtStack,
--#         STree,
--#         Structures,
--#         SystemErrors;
package VCG
--# own Invoked : Boolean;
--# initializes Invoked;
is
   -- The "Invoked" flag is set when the VCG runs and actually generates any VCs.
   -- This is used in MainLoop to warn the user of the common error where a
   -- user runs the Examiner on a package specification expecting VCs to be
   -- generated, but doesn't get any VCs, or (worse) ends up with an old set
   -- of VCs left over from an earlier run.
   Invoked : Boolean := False;

   procedure GenerateVCs (StartNode                 : in     STree.SyntaxNode;
                          Scope                     : in     Dictionary.Scopes;
                          RedType                   : in     CommandLineData.RedTypes;
                          EndPosition               : in     LexTokenManager.TokenPosition;
                          FlowHeap                  : in out Heap.HeapRecord;
                          SemanticErrorInSubprogram : in     Boolean;
                          DataFlowErrorInSubprogram : in     Boolean);
   --# global in     CommandLineData.Content;
   --#        in     STree.Table;
   --#        in out Declarations.State;
   --#        in out Dictionary.Dict;
   --#        in out ErrorHandler.ErrorContext;
   --#        in out Graph.Table;
   --#        in out Invoked;
   --#        in out LexTokenManager.StringTable;
   --#        in out SPARK_IO.FILE_SYS;
   --#        in out Statistics.TableUsage;
   --#        in out StmtStack.S;
   --# derives Declarations.State,
   --#         Dictionary.Dict,
   --#         ErrorHandler.ErrorContext,
   --#         FlowHeap,
   --#         Graph.Table,
   --#         LexTokenManager.StringTable,
   --#         SPARK_IO.FILE_SYS,
   --#         Statistics.TableUsage,
   --#         StmtStack.S                 from *,
   --#                                          CommandLineData.Content,
   --#                                          DataFlowErrorInSubprogram,
   --#                                          Dictionary.Dict,
   --#                                          EndPosition,
   --#                                          ErrorHandler.ErrorContext,
   --#                                          FlowHeap,
   --#                                          LexTokenManager.StringTable,
   --#                                          RedType,
   --#                                          Scope,
   --#                                          SemanticErrorInSubprogram,
   --#                                          SPARK_IO.FILE_SYS,
   --#                                          StartNode,
   --#                                          STree.Table &
   --#         Invoked                     from *,
   --#                                          RedType;
end VCG;
