-- $Id: stringutilities.ads 13063 2009-04-21 12:05:08Z Rod Chapman $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================

with EStrings,
     CommonStringUtilities;

--# inherit CommonStringUtilities,
--#         EStrings;
package StringUtilities
is

   subtype OrderTypes is CommonStringUtilities.OrderTypes;


   -- Section added for use in summary tool
   -- returns the specified subsection of the string
   -- if the subsection lies outside the string, empty string returned
   function Section (EStr     : EStrings.T;
                     StartPos : EStrings.Positions;
                     Length   : EStrings.Lengths)
      return EStrings.T;

   -- Trim added for use in summary tool
   -- removes ' ', Latin_1.HT, Latin_1.LF, Latin_1.CR from either end of the string
   function Trim (EStr : EStrings.T)
      return EStrings.T;

   -- FindSubString: for use in summary tool
   -- find specified SearchString in the given ExaminerString
   procedure FindSubString (EStr         : in     EStrings.T;
                            SearchString : in     String;
                            StringFound  :    out Boolean;
                            StringStart  :    out EStrings.Positions);
   --# derives StringFound,
   --#         StringStart from EStr,
   --#                          SearchString;

   procedure FindExaminerSubString (EStr         : in     EStrings.T;
                                    SearchString : in     EStrings.T;
                                    StringFound  :    out Boolean;
                                    StringStart  :    out EStrings.Positions);
   --# derives StringFound,
   --#         StringStart from EStr,
   --#                          SearchString;

   -- FindSubStringAfter: for use in summary tool
   -- find the specified SearchString, starting at the specified position in
   -- the given ExaminerString
   procedure FindSubStringAfter (EStr         : in     EStrings.T;
                                 SearchStart  : in     EStrings.Positions;
                                 SearchString : in     String;
                                 StringFound  :    out Boolean;
                                 StringStart  :    out EStrings.Positions);
   --# derives StringFound,
   --#         StringStart from EStr,
   --#                          SearchStart,
   --#                          SearchString;

   -- find the specified SearchString, starting at the specified position in
   -- the given ExaminerString
   procedure FindExaminerSubStringAfter (EStr         : in     EStrings.T;
                                         SearchStart  : in     EStrings.Positions;
                                         SearchString : in     EStrings.T;
                                         StringFound  :    out Boolean;
                                         StringStart  :    out EStrings.Positions);
   --# derives StringFound,
   --#         StringStart from EStr,
   --#                          SearchStart,
   --#                          SearchString;

   -- Returns True if and only if SearchString is a sub-string of EStr.
   function IsSubString (EStr         : in EStrings.T;
                         SearchString : in String) return Boolean;

   -- FindCharAfter: find specified character in EStr, starting at specified
   -- position
   procedure FindCharAfter (EStr        : in     EStrings.T;
                            SearchStart : in     EStrings.Positions;
                            SearchChar  : in     Character;
                            CharFound   :    out Boolean;
                            CharPos     :    out EStrings.Positions);
   --# derives CharFound,
   --#         CharPos   from EStr,
   --#                        SearchChar,
   --#                        SearchStart;

   -- FindChar: find first occurrence of specified character in EStr
   procedure FindChar (EStr       : in     EStrings.T;
                       SearchChar : in     Character;
                       CharFound  :    out Boolean;
                       CharPos    :    out EStrings.Positions);
   --# derives CharFound,
   --#         CharPos   from EStr,
   --#                        SearchChar;

   function LexOrder (FirstName, SecondName : EStrings.T)
      return OrderTypes;

end StringUtilities;
