-- $Id: stringutilities.adb 11354 2008-10-06 17:02:56Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================

package body StringUtilities
is

   ----------------------------------------------------------------------------
   -- Section:
   -- returns the specified subsection of the string
   -- if the subsection lies outside the string, empty string returned
   function Section (EStr     : EStrings.T;
                     StartPos : EStrings.Positions;
                     Length   : EStrings.Lengths)
                    return EStrings.T
   is
      ResultStr : EStrings.Contents;
      ResultLen : EStrings.Lengths;

   begin
      CommonStringUtilities.Section (EStr.Content, EStr.Length,
                                     StartPos, Length,
                                     ResultStr, ResultLen);

      return EStrings.T'(Content => ResultStr,
                                             Length  => ResultLen);

   end Section;     -- warning OK, enough of Result.Content defined

   ----------------------------------------------------------------------------
   -- Trim:
   -- removes ' ', Latin_1.HT, Latin_1.LF, Latin_1.CR from either end of the string
   function Trim (EStr : EStrings.T)
                 return EStrings.T
   is
      ResultStr : EStrings.Contents;
      ResultLen : EStrings.Lengths;

   begin -- Trim
      CommonStringUtilities.Trim (EStr.Content, EStr.Length,
                                  ResultStr,    ResultLen);

      return EStrings.T'(Content => ResultStr,
                                             Length  => ResultLen);

   end Trim;

   -------------------------------------------------------------------------
   -- FindSubStringAfter:
   -- find the specified SearchString, starting at the specified position in
   -- the given ExaminerString
   procedure FindSubStringAfter (EStr         : in     EStrings.T;
                                 SearchStart  : in     EStrings.Positions;
                                 SearchString : in     String;
                                 StringFound  :    out Boolean;
                                 StringStart  :    out EStrings.Positions)
   is
   begin
      CommonStringUtilities.FindSubStringAfter (EStr.Content,
                                                EStr.Length,
                                                SearchStart,
                                                SearchString,
                                                SearchString'Length,
                                                StringFound,
                                                StringStart);

   end FindSubStringAfter;

   -------------------------------------------------------------------------
   -- FindExaminerSubStringAfter:
   -- find the specified SearchString, starting at the specified position in
   -- the given ExaminerString
   procedure FindExaminerSubStringAfter (EStr         : in     EStrings.T;
                                         SearchStart  : in     EStrings.Positions;
                                         SearchString : in     EStrings.T;
                                         StringFound  :    out Boolean;
                                         StringStart  :    out EStrings.Positions)
   is
   begin
      CommonStringUtilities.FindSubStringAfter (EStr.Content,
                                                EStr.Length,
                                                SearchStart,
                                                SearchString.Content,
                                                SearchString.Length,
                                                StringFound,
                                                StringStart);

   end FindExaminerSubStringAfter;

   --------------------------------------------------------------------------
   -- FindSubString:
   -- find specified SearchString in the given ExaminerString
   procedure FindSubString (EStr         : in     EStrings.T;
                            SearchString : in     String;
                            StringFound  :    out Boolean;
                            StringStart  :    out EStrings.Positions)
   is
   begin
      FindSubStringAfter (EStr, 1, SearchString, StringFound, StringStart);
   end FindSubString;

   --------------------------------------------------------------------------
   -- FindSubString:
   -- find specified SearchString in the given ExaminerString
   procedure FindExaminerSubString (EStr         : in     EStrings.T;
                                    SearchString : in     EStrings.T;
                                    StringFound  :    out Boolean;
                                    StringStart  :    out EStrings.Positions)
   is
   begin
      FindExaminerSubStringAfter (EStr, 1, SearchString, StringFound, StringStart);
   end FindExaminerSubString;

   --------------------------------------------------------------------------
   -- IsSubString:
   -- Returns True if and only if SearchString is a sub-string of EStr.
   function IsSubString (EStr         : in EStrings.T;
                         SearchString : in String) return Boolean
   is
      StringFound : Boolean;
      StringStart : EStrings.Positions;
   begin
      --# accept Flow, 10, StringStart, "Expected ineffective assignment to StringStart";
      FindSubStringAfter (EStr, 1, SearchString, StringFound, StringStart);
      --# end accept;
      --# accept Flow, 33, StringStart, "Expected StringStart to be neither referenced nor exported";
      return StringFound;
   end IsSubString;

   ---------------------------------------------------------------------------
   -- FindCharAfter: find specified character in EStr, starting at specified
   -- position
   procedure FindCharAfter (EStr        : in     EStrings.T;
                            SearchStart : in     EStrings.Positions;
                            SearchChar  : in     Character;
                            CharFound   :    out Boolean;
                            CharPos     :    out EStrings.Positions)
   is
   begin
      CommonStringUtilities.FindCharAfter (EStr.Content,
                                           EStr.Length,
                                           SearchStart,
                                           SearchChar,
                                           CharFound,
                                           CharPos);

   end FindCharAfter;

   --------------------------------------------------------------------------
   -- FindChar: find first occurrence of specified character in EStr
   procedure FindChar (EStr       : in     EStrings.T;
                       SearchChar : in     Character;
                       CharFound  :    out Boolean;
                       CharPos    :    out EStrings.Positions)
   is
   begin
      FindCharAfter (EStr, 1, SearchChar, CharFound, CharPos);
   end FindChar;

   --------------------------------------------------------------------------
   function LexOrder (FirstName, SecondName : EStrings.T)
                     return OrderTypes
   is
   begin
      return CommonStringUtilities.LexOrder (FirstName.Content,
                                             FirstName.Length,
                                             SecondName.Content,
                                             SecondName.Length);

   end LexOrder;

end StringUtilities;
