-- $Id: statistics.ads 13063 2009-04-21 12:05:08Z Rod Chapman $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


with SPARK_IO;
--# inherit ExaminerConstants,
--#         SPARK_IO,
--#         SystemErrors;
package Statistics
--# own TableUsage : TableUsageArray;
--# initializes TableUsage;
is
   type TableType is (RelationTable,
                      StringTable,
                      SymbolTable,
                      SyntaxTree,
                      VCGHeap,
                      RecordFields,
                      RecordErrors);


   procedure SetTableUsage (Table : in TableType;
                            Size  : in Integer);
   --# global in out TableUsage;
   --# derives TableUsage from *,
   --#                         Size,
   --#                         Table;

   procedure WriteOutput (File : in SPARK_IO.File_Type);
   --# global in     TableUsage;
   --#        in out SPARK_IO.File_Sys;
   --# derives SPARK_IO.File_Sys from *,
   --#                                File,
   --#                                TableUsage;

end Statistics;
