-- $Id: sprint.ads 11354 2008-10-06 17:02:56Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


with STree;

use type STree.SyntaxNode;

--# inherit EStrings,
--#         LexTokenManager,
--#         SPARK_IO,
--#         SPSymbols,
--#         STree;
package SPrint
is

   -- Prints a human-readable printout of the syntax tree rooted at Node
   procedure Dump_Syntax_Tree (Node   : in STree.SyntaxNode;
                               Indent : in Natural);
   --# global in     LexTokenManager.StringTable;
   --#        in     STree.Table;
   --#        in out SPARK_IO.File_Sys;
   --# derives SPARK_IO.File_Sys from *,
   --#                                Indent,
   --#                                LexTokenManager.StringTable,
   --#                                Node,
   --#                                STree.Table;

end SPrint;
