-- $Id: spparsergoto-spgoto.adb 11354 2008-10-06 17:02:56Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


separate (SPParserGoto)
function SPGoto (CST : SPProductions.ValidStates;
                 CSY : SPSymbols.SPNonTerminal) return SPProductions.SPState
is
   IndexPair : PackedGOTIndexPair;
   Index, MaxIndex  : GOTIndex;
   FeasibleState,
   Next_State : SPProductions.SPState;
begin
   IndexPair := NonTermTable (CSY);
   Index := GOTIndex (IndexPair mod GOTIndexSize);
   MaxIndex := GOTIndex (IndexPair / GOTIndexSize);
   FeasibleState := SPProductions.SPState (GotoTable (Index) mod StateSize);
   while FeasibleState /= CST and then Index < MaxIndex loop
      Index := Index + 1;
      FeasibleState := SPProductions.SPState (GotoTable (Index) mod StateSize);
   end loop;
   if FeasibleState /= CST then
      Next_State := 0;
   else
      Next_State :=
         SPProductions.SPState ((GotoTable (Index) / StateSize) mod StateSize);
   end if;
   return Next_State;
end SPGoto;
