-- $Id: spexpectedsymbols-getexpectedsymbols.adb 11354 2008-10-06 17:02:56Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


-- packed version of GetExpectedSymbols.
separate (SPExpectedSymbols)
procedure GetExpectedSymbols (ErrorState       : in     SPProductions.SPState;
                              NoOfTerminals    :    out SPEssSymRange;
                              TerminalList     :    out SPExpSymList;
                              NoOfNonTerminals :    out SPEssSymRange;
                              NonTerminalList  :    out SPExpSymList)
is
   LocEntry     : EssSymbolEntry;
   SymListIndex : ExpSymRange;
   TerminalCount,
   NonTerminalCount : SPEssSymRange;
begin
   LocEntry := ExpectedSymbols (ErrorState);
   SymListIndex := ExpSymRange ((LocEntry / Index) mod IndexLim);
   TerminalCount := SPEssSymRange ((LocEntry / NTerminals) mod TermLim);
   NonTerminalCount := SPEssSymRange ((LocEntry / NNonTerminals) mod NonTermLim);

   for CurrIndex in SPEssSymRange range 1 .. TerminalCount loop
      --# accept Flow, 23, TerminalList, "Expected flow error";
      TerminalList (CurrIndex) := -- 782 - Flow Error expected here.
         EssentialSymbols (SymListIndex);
      --# end accept;

      if CurrIndex < TerminalCount then
         SymListIndex := SymListIndex + 1;
      end if;
   end loop;

   if Natural (NonTerminalCount) > 0 then
      SymListIndex := ExpSymRange ((Natural ((LocEntry / Index) mod IndexLim)) +
                                   Natural (TerminalCount));
      for CurrIndex in SPEssSymRange range 1 .. NonTerminalCount loop
         --# accept Flow, 23, NonTerminalList, "Expected flow error";
         NonTerminalList (CurrIndex) := -- 782 - Flow error expected here
            EssentialSymbols (SymListIndex);
         --# end accept;

         if CurrIndex < NonTerminalCount then
            SymListIndex := SymListIndex + 1;
         end if;
      end loop;
   end if;

   if ErrorState = 1 and then TerminalCount = 0 and then NonTerminalCount = 0 then
      NonTerminalCount := 1;
      --# accept Flow, 504, NonTerminalList, "Expected flow error";
      NonTerminalList (1) := -- 782 - Flow error expected here.
         SPSymbols.SPNonTerminal'Succ (SPSymbols.SPNonTerminal'First);
      --# end accept;
   end if;
   NoOfTerminals := TerminalCount;
   NoOfNonTerminals := NonTerminalCount;

   --# accept Flow, 602, TerminalList, TerminalList, "Expected flow error" &
   --#        Flow, 602, NonTerminalList, NonTerminalList, "Expected flow error";
end GetExpectedSymbols; -- 782 - 2 warnings expected here.
