-- $Id: sparkmain.adb 12952 2009-04-09 13:13:58Z Rod Chapman $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================

with Ada.Command_Line,
     Fatal,
     File_Utils,
     STree,
     Dictionary,
     LexTokenManager,
     Statistics,
     SPARK_IO,
     CommandLineHandler,
     CommandLineData,
     MainLoop,
     ErrorHandler,
     ScreenEcho,
     Version;

--# inherit CommandLineData,
--#         CommandLineHandler,
--#         ConfigFile,
--#         ContextManager,
--#         Declarations,
--#         Dictionary,
--#         ErrorHandler,
--#         File_Utils,
--#         Graph,
--#         IndexManager,
--#         LexTokenManager,
--#         MainLoop,
--#         ScreenEcho,
--#         SparkHTML,
--#         SparkLex,
--#         SPARK_IO,
--#         Statistics,
--#         StmtStack,
--#         STree,
--#         VCG,
--#         Version,
--#         XMLReport;
--# main_program
procedure SparkMain
-- all-from-all derives for data flow analysis only
--# global in out ContextManager.FileHeap;
--#        in out ContextManager.UnitHeap;
--#        in out ContextManager.UnitStack;
--#        in out Declarations.State;
--#        in out ErrorHandler.ErrorContext;
--#        in out Graph.Table;
--#        in out IndexManager.IndexTable;
--#        in out IndexManager.LastChar;
--#        in out LexTokenManager.StringTable;
--#        in out SparkHTML.GenerateHTML;
--#        in out SPARK_IO.File_Sys;
--#        in out Statistics.TableUsage;
--#        in out StmtStack.S;
--#        in out STree.Table;
--#        in out VCG.Invoked;
--#           out CommandLineData.Content;
--#           out ConfigFile.State;
--#           out Dictionary.Dict;
--#           out SparkHTML.HTMLWorkDir;
--#           out SparkHTML.SparkWorkDir;
--#           out SparkLex.CurrLine;
--#           out XMLReport.State;
--# derives CommandLineData.Content     from SPARK_IO.File_Sys &
--#         ConfigFile.State            from ErrorHandler.ErrorContext,
--#                                          LexTokenManager.StringTable,
--#                                          SPARK_IO.File_Sys &
--#         ContextManager.FileHeap,
--#         ErrorHandler.ErrorContext,
--#         IndexManager.IndexTable,
--#         LexTokenManager.StringTable,
--#         XMLReport.State             from ContextManager.FileHeap,
--#                                          ContextManager.UnitHeap,
--#                                          ContextManager.UnitStack,
--#                                          ErrorHandler.ErrorContext,
--#                                          IndexManager.IndexTable,
--#                                          LexTokenManager.StringTable,
--#                                          SparkHTML.GenerateHTML,
--#                                          SPARK_IO.File_Sys,
--#                                          STree.Table &
--#         ContextManager.UnitHeap,
--#         ContextManager.UnitStack,
--#         Declarations.State,
--#         Graph.Table,
--#         IndexManager.LastChar,
--#         Statistics.TableUsage,
--#         StmtStack.S,
--#         STree.Table,
--#         VCG.Invoked                 from *,
--#                                          ContextManager.FileHeap,
--#                                          ContextManager.UnitHeap,
--#                                          ContextManager.UnitStack,
--#                                          ErrorHandler.ErrorContext,
--#                                          LexTokenManager.StringTable,
--#                                          SparkHTML.GenerateHTML,
--#                                          SPARK_IO.File_Sys,
--#                                          STree.Table &
--#         Dictionary.Dict,
--#         SparkHTML.GenerateHTML      from ContextManager.FileHeap,
--#                                          ContextManager.UnitHeap,
--#                                          ContextManager.UnitStack,
--#                                          ErrorHandler.ErrorContext,
--#                                          IndexManager.IndexTable,
--#                                          LexTokenManager.StringTable,
--#                                          SparkHTML.GenerateHTML,
--#                                          SPARK_IO.File_Sys,
--#                                          Statistics.TableUsage,
--#                                          STree.Table &
--#         SparkHTML.HTMLWorkDir,
--#         SparkHTML.SparkWorkDir      from LexTokenManager.StringTable,
--#                                          SPARK_IO.File_Sys &
--#         SparkLex.CurrLine           from ContextManager.FileHeap,
--#                                          ContextManager.UnitHeap,
--#                                          ContextManager.UnitStack,
--#                                          ErrorHandler.ErrorContext,
--#                                          LexTokenManager.StringTable,
--#                                          SparkHTML.GenerateHTML,
--#                                          SPARK_IO.File_Sys,
--#                                          STree.Table &
--#         SPARK_IO.File_Sys           from *,
--#                                          ContextManager.FileHeap,
--#                                          ContextManager.UnitHeap,
--#                                          ContextManager.UnitStack,
--#                                          ErrorHandler.ErrorContext,
--#                                          IndexManager.IndexTable,
--#                                          LexTokenManager.StringTable,
--#                                          SparkHTML.GenerateHTML,
--#                                          Statistics.TableUsage,
--#                                          STree.Table,
--#                                          VCG.Invoked;
is
   procedure Set_Exit_Status (Code : in ErrorHandler.Exit_Code)
   --# derives null from Code;
   is
      --# hide Set_Exit_Status;
   begin
      Ada.Command_Line.Set_Exit_Status (Ada.Command_Line.Exit_Status (Code));
   end Set_Exit_Status;

   procedure Execute
   --# global in     CommandLineData.Content;
   --#        in out ContextManager.FileHeap;
   --#        in out ContextManager.UnitHeap;
   --#        in out ContextManager.UnitStack;
   --#        in out Declarations.State;
   --#        in out ErrorHandler.ErrorContext;
   --#        in out Graph.Table;
   --#        in out IndexManager.IndexTable;
   --#        in out IndexManager.LastChar;
   --#        in out LexTokenManager.StringTable;
   --#        in out SparkHTML.GenerateHTML;
   --#        in out SPARK_IO.File_Sys;
   --#        in out Statistics.TableUsage;
   --#        in out StmtStack.S;
   --#        in out STree.Table;
   --#        in out VCG.Invoked;
   --#           out ConfigFile.State;
   --#           out Dictionary.Dict;
   --#           out SparkHTML.HTMLWorkDir;
   --#           out SparkHTML.SparkWorkDir;
   --#           out SparkLex.CurrLine;
   --#           out XMLReport.State;
   --# derives ConfigFile.State            from CommandLineData.Content,
   --#                                          ErrorHandler.ErrorContext,
   --#                                          LexTokenManager.StringTable,
   --#                                          SPARK_IO.File_Sys &
   --#         ContextManager.FileHeap,
   --#         ErrorHandler.ErrorContext,
   --#         IndexManager.IndexTable,
   --#         LexTokenManager.StringTable,
   --#         XMLReport.State             from CommandLineData.Content,
   --#                                          ContextManager.FileHeap,
   --#                                          ContextManager.UnitHeap,
   --#                                          ContextManager.UnitStack,
   --#                                          ErrorHandler.ErrorContext,
   --#                                          IndexManager.IndexTable,
   --#                                          LexTokenManager.StringTable,
   --#                                          SparkHTML.GenerateHTML,
   --#                                          SPARK_IO.File_Sys,
   --#                                          STree.Table &
   --#         ContextManager.UnitHeap,
   --#         ContextManager.UnitStack,
   --#         Declarations.State,
   --#         Graph.Table,
   --#         IndexManager.LastChar,
   --#         Statistics.TableUsage,
   --#         StmtStack.S,
   --#         STree.Table,
   --#         VCG.Invoked                 from *,
   --#                                          CommandLineData.Content,
   --#                                          ContextManager.FileHeap,
   --#                                          ContextManager.UnitHeap,
   --#                                          ContextManager.UnitStack,
   --#                                          ErrorHandler.ErrorContext,
   --#                                          LexTokenManager.StringTable,
   --#                                          SparkHTML.GenerateHTML,
   --#                                          SPARK_IO.File_Sys,
   --#                                          STree.Table &
   --#         Dictionary.Dict,
   --#         SparkHTML.GenerateHTML      from CommandLineData.Content,
   --#                                          ContextManager.FileHeap,
   --#                                          ContextManager.UnitHeap,
   --#                                          ContextManager.UnitStack,
   --#                                          ErrorHandler.ErrorContext,
   --#                                          IndexManager.IndexTable,
   --#                                          LexTokenManager.StringTable,
   --#                                          SparkHTML.GenerateHTML,
   --#                                          SPARK_IO.File_Sys,
   --#                                          Statistics.TableUsage,
   --#                                          STree.Table &
   --#         SparkHTML.HTMLWorkDir,
   --#         SparkHTML.SparkWorkDir      from CommandLineData.Content,
   --#                                          LexTokenManager.StringTable,
   --#                                          SPARK_IO.File_Sys &
   --#         SparkLex.CurrLine           from CommandLineData.Content,
   --#                                          ContextManager.FileHeap,
   --#                                          ContextManager.UnitHeap,
   --#                                          ContextManager.UnitStack,
   --#                                          ErrorHandler.ErrorContext,
   --#                                          LexTokenManager.StringTable,
   --#                                          SparkHTML.GenerateHTML,
   --#                                          SPARK_IO.File_Sys,
   --#                                          STree.Table &
   --#         SPARK_IO.File_Sys           from *,
   --#                                          CommandLineData.Content,
   --#                                          ContextManager.FileHeap,
   --#                                          ContextManager.UnitHeap,
   --#                                          ContextManager.UnitStack,
   --#                                          ErrorHandler.ErrorContext,
   --#                                          IndexManager.IndexTable,
   --#                                          LexTokenManager.StringTable,
   --#                                          SparkHTML.GenerateHTML,
   --#                                          Statistics.TableUsage,
   --#                                          STree.Table,
   --#                                          VCG.Invoked;
   is
      procedure Star_Line
      --# global in out SPARK_IO.File_Sys;
      --# derives SPARK_IO.File_Sys from *;
      is
      begin
         ScreenEcho.Put_Line
            ("*****************************************************************************");
      end Star_Line;

      procedure Support_Details
      --# global in     CommandLineData.Content;
      --#        in out SPARK_IO.File_Sys;
      --# derives SPARK_IO.File_Sys from *,
      --#                                CommandLineData.Content;
      is
      begin
         -- Suppress support details when in plain mode to avoid
         -- spurious diff when testing non SPARK Pro builds
         if CommandLineData.Content.PlainOutput then
            ScreenEcho.Put_Line ("* Support details - Suppressed in plain mode");
         else
            ScreenEcho.Put_Line ("*");
            ScreenEcho.Put_Line ("* " & Version.Toolset_Support_Line1);
            ScreenEcho.Put_Line ("* " & Version.Toolset_Support_Line2);
            ScreenEcho.Put_Line ("* " & Version.Toolset_Support_Line3);
            ScreenEcho.Put_Line ("* " & Version.Toolset_Support_Line4);
         end if;
      end Support_Details;

   begin
      if CommandLineData.Content.Valid then
         MainLoop.ProcessFiles;
      end if;
      --# accept F, 602, SparkHTML.SparkWorkDir, SparkHTML.SparkWorkDir, "Defined before use in MainLoop" &
      --#        F, 602, SparkHTML.HTMLWorkDir, SparkHTML.HTMLWorkDir, "Defined before use in MainLoop" &
      --#        F, 602, ConfigFile.State, ConfigFile.State, "Defined before use in MainLoop" &
      --#        F, 602, Dictionary.Dict, Dictionary.Dict, "Defined before use in MainLoop" &
      --#        F, 602, SparkLex.CurrLine, SparkLex.CurrLine, "Defined before use in MainLoop" &
      --#        F, 602, XMLReport.State, XMLReport.State, "Defined before use in MainLoop";

   exception
      --# hide Execute;
      when Fatal.StaticLimit           =>
         STree.ReportUsage;
         LexTokenManager.ReportUsage;
         Dictionary.ReportUsage;
         Statistics.WriteOutput (SPARK_IO.Standard_Output);
         Support_Details;
         Star_Line;
         raise;

      when Fatal.OperatingSystemLimit |
         Fatal.InternalError         =>
         Support_Details;
         Star_Line;
         raise;

      when Storage_Error =>
         Star_Line;
         ScreenEcho.Put_Line
            ("* A storage_error has occurred.  You may have too small a system stack limit,");
         ScreenEcho.Put_Line
            ("* insufficient memory or too many other processes running.");
         Support_Details;
         Star_Line;
         raise;

      when others =>
         Star_Line;
         ScreenEcho.Put_Line
            ("* An unexpected internal error has occurred.");
         Support_Details;
         Star_Line;
         raise;

   end Execute;

   procedure PrintHelp
   --# global in out SPARK_IO.File_Sys;
   --# derives SPARK_IO.File_Sys from *;
   is
   begin
      ScreenEcho.Put_Line ("Usage: spark {options} Argument-list");
      ScreenEcho.Put_Line ("Argument-list = Argument {"" "" Argument }");
      ScreenEcho.Put_Line ("Argument = ( File-spec [Argument-option] ) | Meta-file-spec");
      ScreenEcho.Put_Line ("Argument-option = ( ""-listing_file="" file-spec | ""-nolisting_file"" )");
      ScreenEcho.Put_Line ("Meta-file-spec = ""@""file-spec");

      ScreenEcho.New_Line (1);
      ScreenEcho.Put_Line ("Options - all may be abbreviated to the shortest unique prefix");
      ScreenEcho.New_Line (1);
      ScreenEcho.Put_Line ("Input File Options");
      ScreenEcho.Put_Line ("-source_extension=file-type - specifies source file extension (Default .ada)");
      ScreenEcho.Put_Line ("-index_file=file-spec       - specifies index file");
      ScreenEcho.Put_Line ("-noindex_file               - suppress index file (Default)");
      ScreenEcho.Put_Line ("-warning_file=file-spec     - specifies warning control file");
      ScreenEcho.Put_Line ("-nowarning_file             - all warnings reported (Default)");
      ScreenEcho.Put_Line ("-target_compiler_data=file-spec - specifies target compiler data");
      ScreenEcho.Put_Line ("                                  This option is now deprecated by -config_file");
      ScreenEcho.Put_Line ("-notarget_compiler_data         - suppress target compiler data (Default)");
      ScreenEcho.Put_Line ("-config_file=file-spec          - specifies Examiner configuration file");
      ScreenEcho.Put_Line ("-noconfig_file                  - suppress configuration file (Default)");
      ScreenEcho.Put_Line ("-noswitch                       - ignore spark.sw file");
      ScreenEcho.New_Line (1);
      ScreenEcho.Put_Line ("Output File Options");
      ScreenEcho.Put_Line ("-listing_extension=file-type - specifies listing file extension (Default .lst)");
      ScreenEcho.Put_Line ("-report_file=file-spec       - specifies report file name (default SPARK.REP)");
      ScreenEcho.Put_Line ("-noreport_file               - suppress report file");
      ScreenEcho.Put_Line ("-html[=dir_spec]             - Generate HTML listings and report file");
      ScreenEcho.Put_Line ("-output_directory=dir_spec   - Generate report, listing, and proof files");
      ScreenEcho.Put_Line ("                               in specified directory");
      ScreenEcho.Put_Line ("                               Default is in and below current working directory");
      ScreenEcho.Put_Line ("-nolistings                  - suppress all listing files");
      ScreenEcho.Put_Line ("-plain_output                - No dates, line, or error numbers in output files");
      ScreenEcho.New_Line (1);
      ScreenEcho.Put_Line ("Language and Analysis Options");
      ScreenEcho.Put_Line ("-profile=language   - select sequential or ravenscar language profile.");
      ScreenEcho.Put_Line ("                      Default is sequential");
      ScreenEcho.Put_Line ("-ada83              - select SPARK83 rules");
      ScreenEcho.Put_Line ("-noduration         - do not predefine Standard.Duration");
      ScreenEcho.Put_Line ("-syntax_check       - syntax check only.  No semantic checks");
      ScreenEcho.Put_Line ("-flow_analysis=type - select ""information""- or ""data""-flow analysis");
      ScreenEcho.Put_Line ("                    - Default ""information"".  -flow=data is not enabled");
      ScreenEcho.Put_Line ("                    - by default in SPARK83.");
      ScreenEcho.Put_Line ("-rtc          - Generate VCs for partial correctness and run-time checks");
      ScreenEcho.Put_Line ("              - except Overflow_Check");
      ScreenEcho.Put_Line ("-exp_checks   - Generate VCS for partial correctness and run-time checks");
      ScreenEcho.Put_Line ("              - including Overflow_Check");
      ScreenEcho.Put_Line ("-realrtcs     - Generate VCs involving real numbers.");
      ScreenEcho.Put_Line ("              - Please seek advice where using -realrtcs");
      ScreenEcho.Put_Line ("-vcg          - Generate all VCs - equivalent to -exp -real");
      ScreenEcho.Put_Line ("-pfs          - Generate path functions");
      ScreenEcho.Put_Line ("-rules=type   - Select policy for generation of composite constant proof rules");
      ScreenEcho.Put_Line ("              -  valid values: none, lazy, keen, all");
      ScreenEcho.Put_Line ("              -  default: none");

      ScreenEcho.New_Line (1);
      ScreenEcho.Put_Line ("Debugging and Tracing Options");
      ScreenEcho.Put_Line ("-debug[=choices]           - choices is a sequence of letters, where:");
      ScreenEcho.Put_Line ("                             c - trace component manager state");
      ScreenEcho.Put_Line ("                             d - print FDL DAG after BuildExpnDAG");
      ScreenEcho.Put_Line ("                             e - trace expression walking");
      ScreenEcho.Put_Line ("                             f - trace file handling");
      ScreenEcho.Put_Line ("                             h - trace HTML generation");
      ScreenEcho.Put_Line ("                             i - print default loop invariants in FDL");
      ScreenEcho.Put_Line ("                             k - trace ranking and printing of FDL declarations");
      ScreenEcho.Put_Line ("                             l - trace entity lookup in dictionary");
      ScreenEcho.Put_Line ("                             p - print parser state on syntax error");
      ScreenEcho.Put_Line ("                             r - print required and computed flow relations");
      ScreenEcho.Put_Line ("                                 for each subprogram");
      ScreenEcho.Put_Line ("                             u - trace required unit and index file lookups");
      ScreenEcho.Put_Line ("                             v - print VCG State and BPG after DAG.BuildGraph");
      ScreenEcho.Put_Line ("                             V - as v, but also print BPG during each iteration");
      ScreenEcho.Put_Line ("                                 of VC generation");
      ScreenEcho.Put_Line ("-dictionary_file=file-spec - dump Dictionary into given file");
      ScreenEcho.New_Line (1);
      ScreenEcho.Put_Line ("Other Options");
      ScreenEcho.Put_Line ("-annotation_character=char - select alternate annotation character (Default #)");
      ScreenEcho.Put_Line ("-noecho            - suppress screen output");
      ScreenEcho.Put_Line ("-statistics        - append Examiner table usage statistics to report file");
      ScreenEcho.Put_Line ("-nostatistics      - no statistics reported (Default)");
      ScreenEcho.Put_Line ("-fdl_identifiers=option - Control treatment of FDL identifiers");
      ScreenEcho.Put_Line ("                          settings are ""reject"" (Default),");
      ScreenEcho.Put_Line ("                                       ""accept"" or");
      ScreenEcho.Put_Line ("                                       ""<string>""");
      ScreenEcho.Put_Line ("-version           - print Examiner banner, statistics, then exit");
      ScreenEcho.Put_Line ("-brief             - errors and warnings in brief (gcc-style) format");
      ScreenEcho.Put_Line ("-help              - print command line summary and options");
      ScreenEcho.Put_Line ("-original_flow_errors  - print information flow errors in original,");
      ScreenEcho.Put_Line ("                            less compact, format");
      ScreenEcho.Put_Line ("-error_explanations=setting - print explanations after error messages");
      ScreenEcho.Put_Line ("                              settings are ""off"", ""first_occurrence""");
      ScreenEcho.Put_Line ("                                                 or ""every_occurrence""");
      ScreenEcho.Put_Line ("                              default is ""off""");
      ScreenEcho.Put_Line ("-justification_option=type - select policy for justification of errors");
      ScreenEcho.Put_Line ("                           -  values: full, brief, ignore");
      ScreenEcho.Put_Line ("                           -  default: full");
      ScreenEcho.New_Line (1);
      ScreenEcho.Put_Line (Version.Toolset_Support_Line1);
      ScreenEcho.Put_Line (Version.Toolset_Support_Line2);
      ScreenEcho.Put_Line (Version.Toolset_Support_Line3);
      ScreenEcho.Put_Line (Version.Toolset_Support_Line4);
   end PrintHelp;

   procedure MainProcedure
   --# global in out ContextManager.FileHeap;
   --#        in out ContextManager.UnitHeap;
   --#        in out ContextManager.UnitStack;
   --#        in out Declarations.State;
   --#        in out ErrorHandler.ErrorContext;
   --#        in out Graph.Table;
   --#        in out IndexManager.IndexTable;
   --#        in out IndexManager.LastChar;
   --#        in out LexTokenManager.StringTable;
   --#        in out SparkHTML.GenerateHTML;
   --#        in out SPARK_IO.File_Sys;
   --#        in out Statistics.TableUsage;
   --#        in out StmtStack.S;
   --#        in out STree.Table;
   --#        in out VCG.Invoked;
   --#           out CommandLineData.Content;
   --#           out ConfigFile.State;
   --#           out Dictionary.Dict;
   --#           out SparkHTML.HTMLWorkDir;
   --#           out SparkHTML.SparkWorkDir;
   --#           out SparkLex.CurrLine;
   --#           out XMLReport.State;
   --# derives CommandLineData.Content     from SPARK_IO.File_Sys &
   --#         ConfigFile.State            from ErrorHandler.ErrorContext,
   --#                                          LexTokenManager.StringTable,
   --#                                          SPARK_IO.File_Sys &
   --#         ContextManager.FileHeap,
   --#         ErrorHandler.ErrorContext,
   --#         IndexManager.IndexTable,
   --#         LexTokenManager.StringTable,
   --#         XMLReport.State             from ContextManager.FileHeap,
   --#                                          ContextManager.UnitHeap,
   --#                                          ContextManager.UnitStack,
   --#                                          ErrorHandler.ErrorContext,
   --#                                          IndexManager.IndexTable,
   --#                                          LexTokenManager.StringTable,
   --#                                          SparkHTML.GenerateHTML,
   --#                                          SPARK_IO.File_Sys,
   --#                                          STree.Table &
   --#         ContextManager.UnitHeap,
   --#         ContextManager.UnitStack,
   --#         Declarations.State,
   --#         Graph.Table,
   --#         IndexManager.LastChar,
   --#         Statistics.TableUsage,
   --#         StmtStack.S,
   --#         STree.Table,
   --#         VCG.Invoked                 from *,
   --#                                          ContextManager.FileHeap,
   --#                                          ContextManager.UnitHeap,
   --#                                          ContextManager.UnitStack,
   --#                                          ErrorHandler.ErrorContext,
   --#                                          LexTokenManager.StringTable,
   --#                                          SparkHTML.GenerateHTML,
   --#                                          SPARK_IO.File_Sys,
   --#                                          STree.Table &
   --#         Dictionary.Dict,
   --#         SparkHTML.GenerateHTML      from ContextManager.FileHeap,
   --#                                          ContextManager.UnitHeap,
   --#                                          ContextManager.UnitStack,
   --#                                          ErrorHandler.ErrorContext,
   --#                                          IndexManager.IndexTable,
   --#                                          LexTokenManager.StringTable,
   --#                                          SparkHTML.GenerateHTML,
   --#                                          SPARK_IO.File_Sys,
   --#                                          Statistics.TableUsage,
   --#                                          STree.Table &
   --#         SparkHTML.HTMLWorkDir,
   --#         SparkHTML.SparkWorkDir      from LexTokenManager.StringTable,
   --#                                          SPARK_IO.File_Sys &
   --#         SparkLex.CurrLine           from ContextManager.FileHeap,
   --#                                          ContextManager.UnitHeap,
   --#                                          ContextManager.UnitStack,
   --#                                          ErrorHandler.ErrorContext,
   --#                                          LexTokenManager.StringTable,
   --#                                          SparkHTML.GenerateHTML,
   --#                                          SPARK_IO.File_Sys,
   --#                                          STree.Table &
   --#         SPARK_IO.File_Sys           from *,
   --#                                          ContextManager.FileHeap,
   --#                                          ContextManager.UnitHeap,
   --#                                          ContextManager.UnitStack,
   --#                                          ErrorHandler.ErrorContext,
   --#                                          IndexManager.IndexTable,
   --#                                          LexTokenManager.StringTable,
   --#                                          SparkHTML.GenerateHTML,
   --#                                          Statistics.TableUsage,
   --#                                          STree.Table,
   --#                                          VCG.Invoked;
   is
   begin
      CommandLineData.Initialize;

      -- Process the command line before printing the banner, since
      -- the banner depends on the -xxxplain option
      CommandLineHandler.Process;

      if CommandLineData.Content.VersionRequested then
         -- User has requested the Examiner Version banner - we print
         -- this, clean up, and exit with no further action - source
         -- files are not examined.
         File_Utils.PrintAHeader (SPARK_IO.Standard_Output,
                                  "",
                                  File_Utils.OtherFile);
         Statistics.WriteOutput (SPARK_IO.Standard_Output);
         Set_Exit_Status (0);
      elsif CommandLineData.Content.HelpRequested then
         -- User has requested help - we print then banner,
         -- a summary of command line options, clean up, and exit
         -- with no further action - source files are not examined.
         File_Utils.PrintAHeader (SPARK_IO.Standard_Output,
                                  "",
                                  File_Utils.OtherFile);
         PrintHelp;
         Set_Exit_Status (0);
      elsif not CommandLineData.Content.Valid then
         Set_Exit_Status (8);
      else
         CommandLineData.Dump_File_Names;

         if CommandLineData.Content.Valid and then
           CommandLineData.Content.Echo and then
           not CommandLineData.Content.Brief then
            File_Utils.PrintAHeader (SPARK_IO.Standard_Output,
                                     "",
                                     File_Utils.OtherFile);

            -- The Examiner used to print the banner first,
            -- then process the command line.  To make the -plain option work,
            -- though, we have to process the command line first (since the content
            -- of the banner now depends on the command line), THEN print the banner.
            -- The printing of the following message, therefore, has been moved here
            -- to preserve the old look-and-feel of the Examiner.
            if CommandLineData.Content.DefaultSwitchFile then
               ScreenEcho.New_Line (1);
               ScreenEcho.Put_Line ("           Reading default switch file ...");
            end if;

         end if;

         Execute;

         Set_Exit_Status (ErrorHandler.GetErrorsType);
      end if;
      --# accept F, 602, SparkHTML.SparkWorkDir, SparkHTML.SparkWorkDir, "Defined before use in MainLoop" &
      --#        F, 602, SparkHTML.HTMLWorkDir, SparkHTML.HTMLWorkDir, "Defined before use in MainLoop" &
      --#        F, 602, SparkLex.CurrLine, SparkLex.CurrLine, "Defined before use in MainLoop" &
      --#        F, 602, XMLReport.State, XMLReport.State, "Defined before use in MainLoop" &
      --#        F, 602, ConfigFile.State, ConfigFile.State, "Defined before use in MainLoop" &
      --#        F, 602, Dictionary.Dict, Dictionary.Dict, "Defined before use in MainLoop";

   end MainProcedure;

begin
   MainProcedure;
end SparkMain;
