-- $Id: sparklex.ads 13063 2009-04-21 12:05:08Z Rod Chapman $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


with Ada.Characters.Latin_1,
     SPARK_IO,
     SPSymbols,
     LexTokenManager,
     EStrings;

use type SPSymbols.SPSymbol;
use type LexTokenManager.LineNumbers;

--# inherit Ada.Characters.Handling,
--#         Ada.Characters.Latin_1,
--#         CommandLineData,
--#         Dictionary,
--#         ErrorHandler,
--#         EStrings,
--#         LexTokenLists,
--#         LexTokenManager,
--#         SPARK_IO,
--#         SPSymbols,
--#         SystemErrors;
package SparkLex
   --# own CurrLine;
is

   type LineContext is private;

   NullLineContext : constant LineContext;

   procedure ClearLineContext;
   --# global out CurrLine;
   --# derives CurrLine from ;

   procedure StoreLineContext (FileLine : out LineContext);
   --# global in CurrLine;
   --# derives FileLine from CurrLine;

   procedure RestoreLineContext (FileLine : in LineContext);
   --# global out CurrLine;
   --# derives CurrLine from FileLine;

   -- Returns True iff ExStr is an FDL reserved word
   function CheckFDL_RW (ExStr : EStrings.T) return Boolean;

   -- Scan ProgText and return next token found with class Token
   -- and value LexVal.  PunctToken is True iff the scanned token
   -- is deemed to be a "punctutation token" which can be ignored
   -- by the parser.
   --
   -- The exact list of "Punctutation Tokens" is defined in
   -- SPARKLex.Lex.IsPunctToken
   procedure ExaminerLex (ProgText   : in     SPARK_IO.File_Type;
                          Token      :    out SPSymbols.SPTerminal;
                          LexVal     :    out LexTokenManager.LexValue;
                          PunctToken :    out Boolean);
   --# global in     CommandLineData.Content;
   --#        in     Dictionary.Dict;
   --#        in out CurrLine;
   --#        in out ErrorHandler.ErrorContext;
   --#        in out LexTokenManager.StringTable;
   --#        in out SPARK_IO.File_Sys;
   --# derives CurrLine,
   --#         ErrorHandler.ErrorContext,
   --#         LexTokenManager.StringTable,
   --#         LexVal,
   --#         PunctToken,
   --#         SPARK_IO.File_Sys,
   --#         Token                       from CommandLineData.Content,
   --#                                          CurrLine,
   --#                                          Dictionary.Dict,
   --#                                          ErrorHandler.ErrorContext,
   --#                                          LexTokenManager.StringTable,
   --#                                          ProgText,
   --#                                          SPARK_IO.File_Sys;

   -- This version behaves as ExaminerLex, but _allows_ identifiers
   -- beginning with $ to allow for pre-processing and macro-substitution
   -- of such identifiers by tools such as GNATPREP.
   procedure SPARKFormatLex (ProgText   : in     SPARK_IO.File_Type;
                             Token      :    out SPSymbols.SPTerminal;
                             LexVal     :    out LexTokenManager.LexValue;
                             PunctToken :    out Boolean);
   --# global in     CommandLineData.Content;
   --#        in     Dictionary.Dict;
   --#        in out CurrLine;
   --#        in out ErrorHandler.ErrorContext;
   --#        in out LexTokenManager.StringTable;
   --#        in out SPARK_IO.File_Sys;
   --# derives CurrLine,
   --#         ErrorHandler.ErrorContext,
   --#         LexTokenManager.StringTable,
   --#         LexVal,
   --#         PunctToken,
   --#         SPARK_IO.File_Sys,
   --#         Token                       from CommandLineData.Content,
   --#                                          CurrLine,
   --#                                          Dictionary.Dict,
   --#                                          ErrorHandler.ErrorContext,
   --#                                          LexTokenManager.StringTable,
   --#                                          ProgText,
   --#                                          SPARK_IO.File_Sys;


   -- Returns True if Token1 and Token2 are both
   --    Delimiters (such as operators, [ ], and %)
   -- or both Numbers (integers, real, based literals etc.)
   -- or both Character or String literals
   -- or both Identifiers
   -- or both Reserved Words
   -- or both "Others" (not falling into any of the catogories above)
   function SimilarTokens (Token1, Token2 : SPSymbols.SPTerminal) return Boolean;

private

   type ProgramContext is (InAda, InAnnotation);

   type AnnotationContext is (StartAnnotation, MidAnnotation, EndedAnnotation);

   type LineContext is
      record
         Context       : ProgramContext;
         AnnoContext   : AnnotationContext;
         LineNo        : LexTokenManager.LineNumbers;
         LineLength,
         LastTokenPos,
         CurrPos,
         LookaheadPos  : EStrings.Lengths;
         Conts         : EStrings.Line;
      end record;

   NullLineContext : constant LineContext :=
     LineContext'(Context      => InAda,
                  AnnoContext  => StartAnnotation,
                  LineNo       => LexTokenManager.LineNumbers'First,
                  LineLength   => EStrings.Lengths'First,
                  LastTokenPos => EStrings.Lengths'First,
                  CurrPos      => EStrings.Lengths'First,
                  LookaheadPos => EStrings.Lengths'First,
                  Conts        => EStrings.Line'(others => Ada.Characters.Latin_1.NUL));
end SparkLex;
