-- $Id: sparklex-lex-ltintro.adb 11354 2008-10-06 17:02:56Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


separate (SparkLex.Lex)
procedure LTIntro (Token : out SPSymbols.SPTerminal)
is
   Ch1, Ch2 : Character;
begin
   LineManager.AcceptChar; -- less_than already recognised
   LineManager.InspectChar (Ch1);
   case Ch1 is
      when '=' => Token := SPSymbols.less_or_equal;    LineManager.AcceptChar;
      when '>' => Token := SPSymbols.box;              LineManager.AcceptChar;
      when '<' => Token := SPSymbols.left_label_paren; LineManager.AcceptChar;
      when '-' =>
         LineManager.LookaheadChar (Ch2);
         if Ch2 = '>' then
            Token := SPSymbols.is_equivalent_to;
            LineManager.AcceptLookahead;
         else
            Token := SPSymbols.less_than;
            LineManager.RejectLookahead;
         end if;
      when others => Token := SPSymbols.less_than;
   end case;
end LTIntro;
