-- $Id: sparklex-lex-hyphintro.adb 11354 2008-10-06 17:02:56Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


separate (SparkLex.Lex)
procedure HyphIntro (Token : out SPSymbols.SPTerminal)
is
   Ch1, Ch2 : Character;
   AnnoKind : AnnoType;
begin
   -- Hyphen already recognised, but do not accept it in case it introduces the
   -- annotation symbol of an annotation which requires the end_of_annotation
   -- token to inserted infront.
   LineManager.LookaheadChar (Ch1);
   if Ch1 = '-' then
      LineManager.LookaheadChar (Ch2);

      if Ch2 = CommandLineData.Content.AnnoChar then
         if LineManager.CurrLine.AnnoContext = MidAnnotation then
            CheckAnnoType (True, AnnoKind);
         else
            CheckAnnoType (False, AnnoKind);
         end if;

         case AnnoKind is
            when HideAnno =>
               if LineManager.CurrLine.Context = InAnnotation then
                  LineManager.RejectLookahead;
                  Token := SPSymbols.annotation_end;
               else
                  LineManager.AcceptLookahead;
                  Token := SPSymbols.hide_directive;
               end if;
            when StartAnno =>
               if LineManager.CurrLine.Context = InAnnotation then
                  LineManager.RejectLookahead;
                  Token := SPSymbols.annotation_end;
               else
                  LineManager.AcceptLookahead;
                  Token := SPSymbols.annotation_start;
               end if;
            when ProofAnno =>
               if LineManager.CurrLine.Context = InAnnotation then
                  LineManager.RejectLookahead;
                  Token := SPSymbols.annotation_end;
               else
                  LineManager.AcceptLookahead;
                  Token := SPSymbols.proof_context;
               end if;
            when OtherAnno =>
               LineManager.AcceptLookahead;
               -- Making the following assignement means that the if --# is
               -- followed by an identifier (i.e. we have a proof constant declaration)
               -- then the --# will be treated as a beginning a proof context rather
               -- than an annotation.
               Token := SPSymbols.proof_context;
            when NoAnno =>
               LineManager.AcceptLookahead;
               Token := SPSymbols.comment;
         end case;
      else
         LineManager.RejectLookahead;
         LineManager.AcceptChar;
         LineManager.AcceptChar;

         while (Ch2 /= EndOfLine and
                Ch2 /= EndOfText and
                Ch2 /= LineTooLong and not
                FormatEffector (Ch2)) or Ch2 = Ada.Characters.Latin_1.HT
         loop -- Skip comment.
            LineManager.AcceptChar;
            LineManager.InspectChar (Ch2);
         end loop;
         Token := SPSymbols.comment;
      end if;

   elsif Ch1 = '>' then
      LineManager.AcceptLookahead;
      Token := SPSymbols.implies;
   else
      LineManager.RejectLookahead; LineManager.AcceptChar;
      Token := SPSymbols.minus;
   end if;
end HyphIntro;
