-- $Id: sparklex-lex-getstring.adb 11354 2008-10-06 17:02:56Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


separate (SparkLex.Lex)
procedure GetString (Token : out SPSymbols.SPTerminal)
is
   StringNotEnded : Boolean;
   Ch1, Ch2 : Character;
begin
   LineManager.AcceptChar; -- Quotation already recognised
   StringNotEnded := True;
   while StringNotEnded loop
      LineManager.InspectChar (Ch1);
      if Ch1 = '"' then
         LineManager.AcceptChar;
         LineManager.InspectChar (Ch2);
         if Ch2 = '"' then  -- Check for adjacent quotations. (See LRM 2.6).
            LineManager.AcceptChar;      -- Two adjacent quotations - String not ended.
         else
            StringNotEnded := False;
         end if;
      elsif GraphicCharacter (Ch1) then
         LineManager.AcceptChar;
      else
         StringNotEnded := False;
      end if;
   end loop;

   --# accept F, 501, Ch1, "Ch1 always defined on this path";
   if Ch1 = '"' then
      Token := SPSymbols.string_literal;
   else
      Token := SPSymbols.unterminated_string;
   end if;
   --# end accept;


   --# accept F, 602, Token, Ch1, "Ch1 always defined here";
end GetString;
