-- $Id: sparklex-lex-apostintro.adb 11354 2008-10-06 17:02:56Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


separate (SparkLex.Lex)
procedure ApostIntro (Token : out SPSymbols.SPTerminal)
is
   Ch1, Ch2, Ch3, Ch4 : Character;
begin
   LineManager.AcceptChar; -- Apostrophe already recognised
   LineManager.InspectChar (Ch1);
   if GraphicCharacter (Ch1) then
      LineManager.LookaheadChar (Ch2);
      if Ch2 = ''' then
         if Ch1 /= '(' then
            LineManager.AcceptLookahead;  -- Any character literal except for '('.
            Token := SPSymbols.character_literal;
         else
            LineManager.LookaheadChar (Ch3);
            if GraphicCharacter (Ch3) then
               LineManager.LookaheadChar (Ch4);
               LineManager.RejectLookahead;
               if Ch4 = ''' then
                  -- Qualified expression - type_mark'('X'),
                  -- where X is any graphic character.
                  Token := SPSymbols.apostrophe;
               else
                  LineManager.AcceptChar;
                  LineManager.AcceptChar;      -- The character literal '('.
                  Token := SPSymbols.character_literal;
               end if;
            else
               LineManager.RejectLookahead;
               LineManager.AcceptChar;
               LineManager.AcceptChar;        -- The character literal '('.
               Token := SPSymbols.character_literal;
            end if;
         end if;
      else
         LineManager.RejectLookahead;
         Token := SPSymbols.apostrophe;
      end if;
   else
      LineManager.RejectLookahead;
      Token := SPSymbols.apostrophe;
   end if;
end ApostIntro;
